/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.config.model.labels;

import dev.logchange.core.domain.config.model.labels.ConfigurationLabels;
import dev.logchange.core.domain.config.model.labels.TypesLabels;
import org.apache.commons.lang3.StringUtils;

public class Labels {
    public static final String DEFAULT_UNRELEASED_LABEL = "unreleased";
    public static final String DEFAULT_IMPORTANT_NOTES_LABEL = "Important notes";
    public static final Labels EMPTY = Labels.builder().types(TypesLabels.EMPTY).configuration(ConfigurationLabels.EMPTY).build();
    private String unreleased;
    private String importantNotes;
    private TypesLabels types;
    private ConfigurationLabels configuration;

    public String getUnreleased() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.unreleased, (CharSequence)DEFAULT_UNRELEASED_LABEL);
    }

    public String getImportantNotes() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.importantNotes, (CharSequence)DEFAULT_IMPORTANT_NOTES_LABEL);
    }

    public static LabelsBuilder builder() {
        return new LabelsBuilder();
    }

    public TypesLabels getTypes() {
        return this.types;
    }

    public ConfigurationLabels getConfiguration() {
        return this.configuration;
    }

    public Labels(String unreleased, String importantNotes, TypesLabels types, ConfigurationLabels configuration) {
        this.unreleased = unreleased;
        this.importantNotes = importantNotes;
        this.types = types;
        this.configuration = configuration;
    }

    public static class LabelsBuilder {
        private String unreleased;
        private String importantNotes;
        private TypesLabels types;
        private ConfigurationLabels configuration;

        LabelsBuilder() {
        }

        public LabelsBuilder unreleased(String unreleased) {
            this.unreleased = unreleased;
            return this;
        }

        public LabelsBuilder importantNotes(String importantNotes) {
            this.importantNotes = importantNotes;
            return this;
        }

        public LabelsBuilder types(TypesLabels types) {
            this.types = types;
            return this;
        }

        public LabelsBuilder configuration(ConfigurationLabels configuration) {
            this.configuration = configuration;
            return this;
        }

        public Labels build() {
            return new Labels(this.unreleased, this.importantNotes, this.types, this.configuration);
        }

        public String toString() {
            return "Labels.LabelsBuilder(unreleased=" + this.unreleased + ", importantNotes=" + this.importantNotes + ", types=" + this.types + ", configuration=" + this.configuration + ")";
        }
    }
}

