/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.changelog.model;

import dev.logchange.core.domain.changelog.model.ChangelogArchives;
import dev.logchange.core.domain.changelog.model.ChangelogVersions;
import dev.logchange.core.domain.changelog.model.archive.ChangelogArchive;
import dev.logchange.core.domain.changelog.model.version.ChangelogVersion;
import java.util.List;

public class Changelog {
    private final ChangelogVersions versions;
    private final ChangelogArchives archives;

    public static Changelog of(List<ChangelogVersion> versions, List<ChangelogArchive> archives) {
        ChangelogVersions changelogVersions = ChangelogVersions.of(versions);
        ChangelogArchives changelogArchives = ChangelogArchives.of(archives);
        return new Changelog(changelogVersions, changelogArchives);
    }

    private static ChangelogBuilder builder() {
        return new ChangelogBuilder();
    }

    public ChangelogVersions getVersions() {
        return this.versions;
    }

    public ChangelogArchives getArchives() {
        return this.archives;
    }

    private Changelog(ChangelogVersions versions, ChangelogArchives archives) {
        this.versions = versions;
        this.archives = archives;
    }

    private static class ChangelogBuilder {
        private ChangelogVersions versions;
        private ChangelogArchives archives;

        ChangelogBuilder() {
        }

        private ChangelogBuilder versions(ChangelogVersions versions) {
            this.versions = versions;
            return this;
        }

        private ChangelogBuilder archives(ChangelogArchives archives) {
            this.archives = archives;
            return this;
        }

        private Changelog build() {
            return new Changelog(this.versions, this.archives);
        }

        public String toString() {
            return "Changelog.ChangelogBuilder(versions=" + this.versions + ", archives=" + this.archives + ")";
        }
    }
}

