/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.yml.config;

import de.beosign.snakeyamlanno.constructor.AnnotationAwareConstructor;
import de.beosign.snakeyamlanno.property.YamlAnySetter;
import de.beosign.snakeyamlanno.property.YamlProperty;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.domain.config.model.Heading;
import dev.logchange.core.domain.config.model.labels.Labels;
import dev.logchange.core.format.yml.YamlProvider;
import dev.logchange.core.format.yml.config.YMLChangelog;
import java.io.InputStream;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public class YMLConfig {
    private static final String YML_HEADING = "# This file configures logchange tool \ud83c\udf33 \ud83e\ude93 => \ud83e\udeb5 \n# Visit https://github.com/logchange/logchange and leave a star \ud83c\udf1f \n# More info about configuration you can find https://github.com/logchange/logchange#configuration \n";
    @YamlProperty(key="changelog", order=0)
    public YMLChangelog changelog;

    public static YMLConfig of(InputStream input) {
        Yaml yaml = new Yaml((BaseConstructor)new AnnotationAwareConstructor(YMLConfig.class));
        return (YMLConfig)yaml.load(input);
    }

    public static YMLConfig of(Config config) {
        return YMLConfig.builder().changelog(YMLChangelog.of(config)).build();
    }

    public String toYMLString() {
        return YML_HEADING + YamlProvider.get().dumpAsMap((Object)this);
    }

    @YamlAnySetter
    public void anySetter(String key, Object value) {
        System.out.println("Unknown property: " + key + " with value " + value);
    }

    public Config to() {
        return Config.builder().heading(this.getHeading()).labels(this.getLabels()).build();
    }

    private Labels getLabels() {
        if (this.changelog == null) {
            return Labels.EMPTY;
        }
        return this.changelog.getLabels();
    }

    private Heading getHeading() {
        if (this.changelog == null) {
            return Heading.EMPTY;
        }
        return this.changelog.getHeading();
    }

    public static YMLConfigBuilder builder() {
        return new YMLConfigBuilder();
    }

    public YMLConfig() {
    }

    public YMLConfig(YMLChangelog changelog) {
        this.changelog = changelog;
    }

    public static class YMLConfigBuilder {
        private YMLChangelog changelog;

        YMLConfigBuilder() {
        }

        public YMLConfigBuilder changelog(YMLChangelog changelog) {
            this.changelog = changelog;
            return this;
        }

        public YMLConfig build() {
            return new YMLConfig(this.changelog);
        }

        public String toString() {
            return "YMLConfig.YMLConfigBuilder(changelog=" + this.changelog + ")";
        }
    }
}

