/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.yml.changelog.entry;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryType;

public enum YMLChangelogEntryType {
    ADDED("added"),
    CHANGED("changed"),
    DEPRECATED("deprecated"),
    REMOVED("removed"),
    FIXED("fixed"),
    SECURITY("security"),
    OTHER("other");

    private final String type;

    static YMLChangelogEntryType of(ChangelogEntryType type) {
        switch (type) {
            case ADDED: {
                return ADDED;
            }
            case CHANGED: {
                return CHANGED;
            }
            case DEPRECATED: {
                return DEPRECATED;
            }
            case REMOVED: {
                return REMOVED;
            }
            case FIXED: {
                return FIXED;
            }
            case SECURITY: {
                return SECURITY;
            }
            case OTHER: {
                return OTHER;
            }
        }
        throw new IllegalArgumentException("Converting ChangelogEntryType failed");
    }

    ChangelogEntryType to() {
        switch (this) {
            case ADDED: {
                return ChangelogEntryType.ADDED;
            }
            case CHANGED: {
                return ChangelogEntryType.CHANGED;
            }
            case DEPRECATED: {
                return ChangelogEntryType.DEPRECATED;
            }
            case REMOVED: {
                return ChangelogEntryType.REMOVED;
            }
            case FIXED: {
                return ChangelogEntryType.FIXED;
            }
            case SECURITY: {
                return ChangelogEntryType.SECURITY;
            }
            case OTHER: {
                return ChangelogEntryType.OTHER;
            }
        }
        throw new IllegalArgumentException("Converting ChangelogEntryType failed");
    }

    public String getType() {
        return this.type;
    }

    private YMLChangelogEntryType(String type) {
        this.type = type;
    }
}

