/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.config.model.labels;

import dev.logchange.core.domain.config.model.labels.ConfigurationActionLabels;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationLabels {
    public static final String DEFAULT_HEADING_LABEL = "Configuration changes";
    public static final String DEFAULT_TYPE_LABEL = "Type";
    public static final String DEFAULT_WITH_DEFAULT_VALUE_LABEL = "with default value";
    public static final String DEFAULT_DESCRIPTION_LABEL = "Description";
    public static final ConfigurationLabels EMPTY = ConfigurationLabels.builder().actions(ConfigurationActionLabels.EMPTY).build();
    private String heading;
    private String type;
    private ConfigurationActionLabels actions;
    private String withDefaultValue;
    private String description;

    public String getHeading() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.heading, (CharSequence)DEFAULT_HEADING_LABEL);
    }

    public String getType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.type, (CharSequence)DEFAULT_TYPE_LABEL);
    }

    public String getWithDefaultValue() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.withDefaultValue, (CharSequence)DEFAULT_WITH_DEFAULT_VALUE_LABEL);
    }

    public String getDescription() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.description, (CharSequence)DEFAULT_DESCRIPTION_LABEL);
    }

    public static ConfigurationLabelsBuilder builder() {
        return new ConfigurationLabelsBuilder();
    }

    public ConfigurationActionLabels getActions() {
        return this.actions;
    }

    public ConfigurationLabels(String heading, String type, ConfigurationActionLabels actions, String withDefaultValue, String description) {
        this.heading = heading;
        this.type = type;
        this.actions = actions;
        this.withDefaultValue = withDefaultValue;
        this.description = description;
    }

    public static class ConfigurationLabelsBuilder {
        private String heading;
        private String type;
        private ConfigurationActionLabels actions;
        private String withDefaultValue;
        private String description;

        ConfigurationLabelsBuilder() {
        }

        public ConfigurationLabelsBuilder heading(String heading) {
            this.heading = heading;
            return this;
        }

        public ConfigurationLabelsBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ConfigurationLabelsBuilder actions(ConfigurationActionLabels actions) {
            this.actions = actions;
            return this;
        }

        public ConfigurationLabelsBuilder withDefaultValue(String withDefaultValue) {
            this.withDefaultValue = withDefaultValue;
            return this;
        }

        public ConfigurationLabelsBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ConfigurationLabels build() {
            return new ConfigurationLabels(this.heading, this.type, this.actions, this.withDefaultValue, this.description);
        }

        public String toString() {
            return "ConfigurationLabels.ConfigurationLabelsBuilder(heading=" + this.heading + ", type=" + this.type + ", actions=" + this.actions + ", withDefaultValue=" + this.withDefaultValue + ", description=" + this.description + ")";
        }
    }
}

