/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.config.model.labels;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryConfigurationAction;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationActionLabels {
    public static final String DEFAULT_ADD_LABEL = "Added";
    public static final String DEFAULT_UPDATE_LABEL = "Updated";
    public static final String DEFAULT_DELETE_LABEL = "Deleted";
    public static final ConfigurationActionLabels EMPTY = ConfigurationActionLabels.builder().build();
    private String add;
    private String update;
    private String delete;

    public String getAction(ChangelogEntryConfigurationAction action) {
        switch (action) {
            case ADD: {
                return (String)StringUtils.defaultIfBlank((CharSequence)this.add, (CharSequence)DEFAULT_ADD_LABEL);
            }
            case UPDATE: {
                return (String)StringUtils.defaultIfBlank((CharSequence)this.update, (CharSequence)DEFAULT_UPDATE_LABEL);
            }
            case DELETE: {
                return (String)StringUtils.defaultIfBlank((CharSequence)this.delete, (CharSequence)DEFAULT_DELETE_LABEL);
            }
        }
        throw new IllegalArgumentException("Unrecognized action: " + (Object)((Object)action));
    }

    public static ConfigurationActionLabelsBuilder builder() {
        return new ConfigurationActionLabelsBuilder();
    }

    public ConfigurationActionLabels(String add, String update, String delete) {
        this.add = add;
        this.update = update;
        this.delete = delete;
    }

    public static class ConfigurationActionLabelsBuilder {
        private String add;
        private String update;
        private String delete;

        ConfigurationActionLabelsBuilder() {
        }

        public ConfigurationActionLabelsBuilder add(String add) {
            this.add = add;
            return this;
        }

        public ConfigurationActionLabelsBuilder update(String update) {
            this.update = update;
            return this;
        }

        public ConfigurationActionLabelsBuilder delete(String delete) {
            this.delete = delete;
            return this;
        }

        public ConfigurationActionLabels build() {
            return new ConfigurationActionLabels(this.add, this.update, this.delete);
        }

        public String toString() {
            return "ConfigurationActionLabels.ConfigurationActionLabelsBuilder(add=" + this.add + ", update=" + this.update + ", delete=" + this.delete + ")";
        }
    }
}

