/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.changelog.model.entry;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryConfigurationAction;
import java.util.Comparator;

public class ChangelogEntryConfiguration
implements Comparable<ChangelogEntryConfiguration> {
    private final String type;
    private final ChangelogEntryConfigurationAction action;
    private final String key;
    private final String defaultValue;
    private final String description;
    private final String moreInfo;

    @Override
    public int compareTo(ChangelogEntryConfiguration o) {
        return Comparator.comparing(ChangelogEntryConfiguration::getType).thenComparing(ChangelogEntryConfiguration::getAction).thenComparing(ChangelogEntryConfiguration::getKey).compare(this, o);
    }

    public static ChangelogEntryConfiguration of(String type, ChangelogEntryConfigurationAction action, String key, String defaultValue, String description, String moreInfo) {
        return ChangelogEntryConfiguration.builder().type(type).action(action).key(key).defaultValue(defaultValue).description(description).moreInfo(moreInfo).build();
    }

    ChangelogEntryConfiguration(String type, ChangelogEntryConfigurationAction action, String key, String defaultValue, String description, String moreInfo) {
        this.type = type;
        this.action = action;
        this.key = key;
        this.defaultValue = defaultValue;
        this.description = description;
        this.moreInfo = moreInfo;
    }

    private static ChangelogEntryConfigurationBuilder builder() {
        return new ChangelogEntryConfigurationBuilder();
    }

    public String getType() {
        return this.type;
    }

    public ChangelogEntryConfigurationAction getAction() {
        return this.action;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMoreInfo() {
        return this.moreInfo;
    }

    public String toString() {
        return "ChangelogEntryConfiguration(type=" + this.getType() + ", action=" + (Object)((Object)this.getAction()) + ", key=" + this.getKey() + ", defaultValue=" + this.getDefaultValue() + ", description=" + this.getDescription() + ", moreInfo=" + this.getMoreInfo() + ")";
    }

    private static class ChangelogEntryConfigurationBuilder {
        private String type;
        private ChangelogEntryConfigurationAction action;
        private String key;
        private String defaultValue;
        private String description;
        private String moreInfo;

        ChangelogEntryConfigurationBuilder() {
        }

        private ChangelogEntryConfigurationBuilder type(String type) {
            this.type = type;
            return this;
        }

        private ChangelogEntryConfigurationBuilder action(ChangelogEntryConfigurationAction action) {
            this.action = action;
            return this;
        }

        private ChangelogEntryConfigurationBuilder key(String key) {
            this.key = key;
            return this;
        }

        private ChangelogEntryConfigurationBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        private ChangelogEntryConfigurationBuilder description(String description) {
            this.description = description;
            return this;
        }

        private ChangelogEntryConfigurationBuilder moreInfo(String moreInfo) {
            this.moreInfo = moreInfo;
            return this;
        }

        private ChangelogEntryConfiguration build() {
            return new ChangelogEntryConfiguration(this.type, this.action, this.key, this.defaultValue, this.description, this.moreInfo);
        }

        public String toString() {
            return "ChangelogEntryConfiguration.ChangelogEntryConfigurationBuilder(type=" + this.type + ", action=" + (Object)((Object)this.action) + ", key=" + this.key + ", defaultValue=" + this.defaultValue + ", description=" + this.description + ", moreInfo=" + this.moreInfo + ")";
        }
    }
}

