/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.md.changelog.version;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryConfiguration;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.format.md.MD;
import dev.logchange.core.format.md.MDList;
import dev.logchange.core.format.md.changelog.Configurable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.steppschuh.markdowngenerator.table.Table;
import net.steppschuh.markdowngenerator.text.code.Code;
import net.steppschuh.markdowngenerator.text.heading.Heading;

class MDChangelogVersionConfiguration
extends Configurable
implements MD {
    private final List<ChangelogEntryConfiguration> configurations;

    public MDChangelogVersionConfiguration(List<ChangelogEntryConfiguration> configurations, Config config) {
        super(config);
        this.configurations = configurations;
    }

    public String toString() {
        return this.getConfiguration();
    }

    private String getConfiguration() {
        if (this.configurations.size() != 0) {
            StringBuilder markdownConfiguration = new StringBuilder(new Heading((Object)this.getConfig().getLabels().getConfiguration().getHeading(), 3) + "\n\n");
            Set<String> types = this.getConfigurationsTypes();
            for (String type : types) {
                markdownConfiguration.append(this.getConfigurationTable(this.configurations, type)).append("\n\n");
            }
            return markdownConfiguration.toString();
        }
        return "";
    }

    private Set<String> getConfigurationsTypes() {
        return ((Stream)this.configurations.stream().sequential()).map(ChangelogEntryConfiguration::getType).collect(Collectors.toSet());
    }

    private Table getConfigurationTable(List<ChangelogEntryConfiguration> configurations, String type) {
        Table.Builder tableBuilder = new Table.Builder().addRow(new Object[]{this.getConfig().getLabels().getConfiguration().getType() + ": " + type});
        for (ChangelogEntryConfiguration configuration : configurations) {
            MDList configDetails = new MDList();
            configDetails.add(this.getConfig().getLabels().getConfiguration().getActions().getAction(configuration.getAction()) + " " + new Code((Object)configuration.getKey()) + " " + this.getConfig().getLabels().getConfiguration().getWithDefaultValue() + ": " + new Code((Object)configuration.getDefaultValue()));
            configDetails.add(this.getConfig().getLabels().getConfiguration().getDescription() + ": " + configuration.getDescription());
            configDetails.add(configuration.getMoreInfo());
            tableBuilder.addRow(new Object[]{configDetails});
        }
        return tableBuilder.build();
    }
}

