/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.config.model.labels;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryType;
import dev.logchange.core.domain.config.model.labels.NumberOfChangesLabels;
import org.apache.commons.lang3.StringUtils;

public class TypesLabels {
    public static final String DEFAULT_ADDED_LABEL = "Added";
    public static final String DEFAULT_CHANGED_LABEL = "Changed";
    public static final String DEFAULT_DEPRECATED_LABEL = "Deprecated";
    public static final String DEFAULT_REMOVED_LABEL = "Removed";
    public static final String DEFAULT_FIXED_LABEL = "Fixed";
    public static final String DEFAULT_SECURITY_LABEL = "Security";
    public static final String DEFAULT_OTHER_LABEL = "Other";
    public static final TypesLabels EMPTY = TypesLabels.builder().numberOfChanges(NumberOfChangesLabels.EMPTY).build();
    private String added;
    private String changed;
    private String deprecated;
    private String removed;
    private String fixed;
    private String security;
    private String other;
    private NumberOfChangesLabels numberOfChanges;

    public String getType(ChangelogEntryType type) {
        switch (type) {
            case ADDED: {
                return (String)StringUtils.defaultIfBlank((CharSequence)this.added, (CharSequence)DEFAULT_ADDED_LABEL);
            }
            case CHANGED: {
                return (String)StringUtils.defaultIfBlank((CharSequence)this.changed, (CharSequence)DEFAULT_CHANGED_LABEL);
            }
            case DEPRECATED: {
                return (String)StringUtils.defaultIfBlank((CharSequence)this.deprecated, (CharSequence)DEFAULT_DEPRECATED_LABEL);
            }
            case REMOVED: {
                return (String)StringUtils.defaultIfBlank((CharSequence)this.removed, (CharSequence)DEFAULT_REMOVED_LABEL);
            }
            case FIXED: {
                return (String)StringUtils.defaultIfBlank((CharSequence)this.fixed, (CharSequence)DEFAULT_FIXED_LABEL);
            }
            case SECURITY: {
                return (String)StringUtils.defaultIfBlank((CharSequence)this.security, (CharSequence)DEFAULT_SECURITY_LABEL);
            }
            case OTHER: {
                return (String)StringUtils.defaultIfBlank((CharSequence)this.other, (CharSequence)DEFAULT_OTHER_LABEL);
            }
        }
        throw new IllegalArgumentException("Unrecognized type: " + (Object)((Object)type));
    }

    public static TypesLabelsBuilder builder() {
        return new TypesLabelsBuilder();
    }

    public TypesLabels(String added, String changed, String deprecated, String removed, String fixed, String security, String other, NumberOfChangesLabels numberOfChanges) {
        this.added = added;
        this.changed = changed;
        this.deprecated = deprecated;
        this.removed = removed;
        this.fixed = fixed;
        this.security = security;
        this.other = other;
        this.numberOfChanges = numberOfChanges;
    }

    public NumberOfChangesLabels getNumberOfChanges() {
        return this.numberOfChanges;
    }

    public static class TypesLabelsBuilder {
        private String added;
        private String changed;
        private String deprecated;
        private String removed;
        private String fixed;
        private String security;
        private String other;
        private NumberOfChangesLabels numberOfChanges;

        TypesLabelsBuilder() {
        }

        public TypesLabelsBuilder added(String added) {
            this.added = added;
            return this;
        }

        public TypesLabelsBuilder changed(String changed) {
            this.changed = changed;
            return this;
        }

        public TypesLabelsBuilder deprecated(String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public TypesLabelsBuilder removed(String removed) {
            this.removed = removed;
            return this;
        }

        public TypesLabelsBuilder fixed(String fixed) {
            this.fixed = fixed;
            return this;
        }

        public TypesLabelsBuilder security(String security) {
            this.security = security;
            return this;
        }

        public TypesLabelsBuilder other(String other) {
            this.other = other;
            return this;
        }

        public TypesLabelsBuilder numberOfChanges(NumberOfChangesLabels numberOfChanges) {
            this.numberOfChanges = numberOfChanges;
            return this;
        }

        public TypesLabels build() {
            return new TypesLabels(this.added, this.changed, this.deprecated, this.removed, this.fixed, this.security, this.other, this.numberOfChanges);
        }

        public String toString() {
            return "TypesLabels.TypesLabelsBuilder(added=" + this.added + ", changed=" + this.changed + ", deprecated=" + this.deprecated + ", removed=" + this.removed + ", fixed=" + this.fixed + ", security=" + this.security + ", other=" + this.other + ", numberOfChanges=" + this.numberOfChanges + ")";
        }
    }
}

