/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.changelog.model.version;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntry;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryConfiguration;
import dev.logchange.core.domain.changelog.model.version.Version;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ChangelogVersion
implements Comparable<ChangelogVersion> {
    private final Version version;
    private final OffsetDateTime releaseDateTime;
    private final List<ChangelogEntry> entries;

    @Override
    public int compareTo(ChangelogVersion o) {
        return this.version.compareTo(o.version);
    }

    public List<String> getImportantNotes() {
        return ((Stream)this.entries.stream().sequential()).map(ChangelogEntry::getImportantNotes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ChangelogEntryConfiguration> getConfigurations() {
        return this.entries.stream().map(ChangelogEntry::getConfigurations).flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    public static ChangelogVersionBuilder builder() {
        return new ChangelogVersionBuilder();
    }

    public Version getVersion() {
        return this.version;
    }

    public OffsetDateTime getReleaseDateTime() {
        return this.releaseDateTime;
    }

    public List<ChangelogEntry> getEntries() {
        return this.entries;
    }

    private ChangelogVersion(Version version, OffsetDateTime releaseDateTime, List<ChangelogEntry> entries) {
        this.version = version;
        this.releaseDateTime = releaseDateTime;
        this.entries = entries;
    }

    public static class ChangelogVersionBuilder {
        private Version version;
        private OffsetDateTime releaseDateTime;
        private List<ChangelogEntry> entries;

        ChangelogVersionBuilder() {
        }

        public ChangelogVersionBuilder version(Version version) {
            this.version = version;
            return this;
        }

        public ChangelogVersionBuilder releaseDateTime(OffsetDateTime releaseDateTime) {
            this.releaseDateTime = releaseDateTime;
            return this;
        }

        public ChangelogVersionBuilder entries(List<ChangelogEntry> entries) {
            this.entries = entries;
            return this;
        }

        public ChangelogVersion build() {
            return new ChangelogVersion(this.version, this.releaseDateTime, this.entries);
        }

        public String toString() {
            return "ChangelogVersion.ChangelogVersionBuilder(version=" + this.version + ", releaseDateTime=" + this.releaseDateTime + ", entries=" + this.entries + ")";
        }
    }
}

