/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.infrastructure.persistance.changelog;

import dev.logchange.core.application.changelog.repository.ChangelogRepository;
import dev.logchange.core.domain.changelog.model.Changelog;
import dev.logchange.core.domain.changelog.model.archive.ChangelogArchive;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntry;
import dev.logchange.core.domain.changelog.model.version.ChangelogVersion;
import dev.logchange.core.domain.changelog.model.version.Version;
import dev.logchange.core.format.md.changelog.MDChangelog;
import dev.logchange.core.format.release_date.ReleaseDate;
import dev.logchange.core.format.yml.changelog.entry.YMLChangelogEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileChangelogRepository
implements ChangelogRepository {
    private final File inputDirectory;
    private final File outputFile;

    public FileChangelogRepository(File inputDirectory, File outputFile) {
        this.inputDirectory = inputDirectory;
        this.outputFile = outputFile;
    }

    @Override
    public Changelog find() {
        List<File> inputFiles = this.getInputFiles();
        LinkedList<ChangelogVersion> versions = new LinkedList<ChangelogVersion>();
        LinkedList<ChangelogArchive> archives = new LinkedList<ChangelogArchive>();
        for (File file : inputFiles) {
            if (this.isVersionDirectory(file)) {
                versions.add(this.getChangelogVersion(file));
            }
            if (!this.isArchive(file)) continue;
            archives.add(this.getChangelogArchive(file));
        }
        versions.sort(Collections.reverseOrder());
        return Changelog.of(versions, archives);
    }

    @Override
    public void save(Changelog changelog) {
        String md = new MDChangelog(changelog).toMD();
        try (PrintWriter out = new PrintWriter(this.outputFile);){
            out.println(md);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not save changelog to file: " + this.outputFile + " because: " + e.getMessage());
        }
    }

    private List<File> getInputFiles() {
        File[] files = this.inputDirectory.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    private boolean isVersionDirectory(File file) {
        return file.isDirectory();
    }

    private boolean isArchive(File file) {
        return file.getName().startsWith("archive");
    }

    private ChangelogVersion getChangelogVersion(File versionDirectory) {
        return ChangelogVersion.builder().version(this.getVersion(versionDirectory)).entries(this.getEntries(versionDirectory)).releaseDateTime(ReleaseDate.getFromDir(versionDirectory)).build();
    }

    private ChangelogArchive getChangelogArchive(File file) {
        try {
            return ChangelogArchive.of(Files.readAllLines(file.toPath(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    private Version getVersion(File versionDirectory) {
        return Version.of(versionDirectory.getName().replace("v", ""));
    }

    private List<ChangelogEntry> getEntries(File versionDirectory) {
        return this.getEntriesFiles(versionDirectory).map(file -> YMLChangelogEntry.of(this.getEntryInputStream((File)file))).map(YMLChangelogEntry::to).collect(Collectors.toList());
    }

    private Stream<File> getEntriesFiles(File versionDirectory) {
        File[] entriesFiles = versionDirectory.listFiles();
        if (entriesFiles == null) {
            return Stream.empty();
        }
        return Arrays.stream(entriesFiles).filter(file -> file.getName().contains(".yml") || file.getName().contains(".yaml"));
    }

    private InputStream getEntryInputStream(File entryFile) {
        try {
            return new FileInputStream(entryFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Cannot find entry file: " + entryFile.getName());
        }
    }
}

