/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.md.changelog.version;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryConfiguration;
import dev.logchange.core.format.md.MD;
import dev.logchange.core.format.md.MDList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.steppschuh.markdowngenerator.table.Table;
import net.steppschuh.markdowngenerator.text.code.Code;
import net.steppschuh.markdowngenerator.text.heading.Heading;

class MDChangelogVersionConfiguration
implements MD {
    private final List<ChangelogEntryConfiguration> configurations;

    public MDChangelogVersionConfiguration(List<ChangelogEntryConfiguration> configurations) {
        this.configurations = configurations;
    }

    public String toString() {
        return this.getConfiguration();
    }

    private String getConfiguration() {
        if (this.configurations.size() != 0) {
            StringBuilder markdownConfiguration = new StringBuilder(new Heading((Object)"Configuration changes", 3) + "\n\n");
            Set<String> types = this.getConfigurationsTypes();
            for (String type : types) {
                markdownConfiguration.append(this.getConfigurationTable(this.configurations, type)).append("\n\n");
            }
            return markdownConfiguration.toString();
        }
        return "";
    }

    private Set<String> getConfigurationsTypes() {
        return this.configurations.stream().map(ChangelogEntryConfiguration::getType).collect(Collectors.toSet());
    }

    private Table getConfigurationTable(List<ChangelogEntryConfiguration> configurations, String type) {
        Table.Builder tableBuilder = new Table.Builder().addRow(new Object[]{"Type: " + type});
        for (ChangelogEntryConfiguration configuration : configurations) {
            MDList configDetails = new MDList();
            configDetails.add(configuration.getAction().getDisplayText() + new Code((Object)configuration.getKey()) + " with default value: " + new Code((Object)configuration.getDefaultValue()));
            configDetails.add("Description: " + configuration.getDescription());
            configDetails.add(configuration.getMoreInfo());
            tableBuilder.addRow(new Object[]{configDetails});
        }
        return tableBuilder.build();
    }
}

