/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.md.changelog.version;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntry;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryType;
import dev.logchange.core.format.md.MD;
import dev.logchange.core.format.md.changelog.entry.MDChangelogEntry;
import java.util.List;
import java.util.stream.Collectors;
import net.steppschuh.markdowngenerator.text.heading.Heading;
import org.apache.commons.lang3.StringUtils;

class MDChangelogEntriesGroup
implements MD {
    private final ChangelogEntryType type;
    private final List<ChangelogEntry> entries;

    MDChangelogEntriesGroup(ChangelogEntryType type, List<ChangelogEntry> entries) {
        this.type = type;
        this.entries = entries.stream().filter(changelogEntry -> type.equals((Object)changelogEntry.getType())).collect(Collectors.toList());
    }

    public String toString() {
        return this.getEntries();
    }

    private String getEntries() {
        if (this.entries == null || this.entries.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeHeading()).append("\n").append("\n");
        for (ChangelogEntry entry : this.entries) {
            stringBuilder.append(new MDChangelogEntry(entry)).append("\n");
        }
        return stringBuilder.append("\n").toString();
    }

    private Heading getTypeHeading() {
        return new Heading((Object)(StringUtils.capitalize((String)this.type.getType()) + " " + this.getChangesNumber(this.entries)), 3);
    }

    private String getChangesNumber(List<ChangelogEntry> entriesByType) {
        return "(" + entriesByType.size() + " change" + (entriesByType.size() > 1 ? "s" : "") + ")";
    }
}

