/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.changelog.model.version;

import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class Version
implements Comparable<Version> {
    public static final String UNRELEASED = "unreleased";
    private final String value;

    public static Version of(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be black!");
        }
        return new Version(version);
    }

    @Override
    public int compareTo(Version other) {
        if (UNRELEASED.equals(this.value)) {
            return 1;
        }
        if (UNRELEASED.equals(other.value)) {
            return -1;
        }
        if (this.value.equals(other.value)) {
            return 0;
        }
        return Comparator.comparing(Version::getComparableVersion).compare(this, other);
    }

    private ComparableVersion getComparableVersion() {
        return new ComparableVersion(this.value);
    }

    public String getDirName() {
        if (UNRELEASED.equals(this.value)) {
            return this.value;
        }
        return "v" + this.value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Version;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    private Version(String value) {
        this.value = value;
    }
}

