/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.changelog.model.entry;

public enum ChangelogEntryType {
    ADDED("added", 1),
    CHANGED("changed", 2),
    DEPRECATED("deprecated", 3),
    REMOVED("removed", 4),
    FIXED("fixed", 5),
    SECURITY("security", 6);

    private final String type;
    private final Integer order;

    public static ChangelogEntryType from(String orderNumber) {
        for (ChangelogEntryType type : ChangelogEntryType.values()) {
            if (!type.getOrder().toString().equals(orderNumber)) continue;
            return type;
        }
        throw new IllegalArgumentException("Incorrect type!");
    }

    public String toString() {
        return this.order + ". " + this.type;
    }

    public String getType() {
        return this.type;
    }

    public Integer getOrder() {
        return this.order;
    }

    private ChangelogEntryType(String type, Integer order) {
        this.type = type;
        this.order = order;
    }
}

