/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.changelog.model;

import dev.logchange.core.domain.changelog.model.ChangelogArchives;
import dev.logchange.core.domain.changelog.model.ChangelogHeading;
import dev.logchange.core.domain.changelog.model.ChangelogVersions;
import dev.logchange.core.domain.changelog.model.archive.ChangelogArchive;
import dev.logchange.core.domain.changelog.model.version.ChangelogVersion;
import java.util.List;

public class Changelog {
    private final ChangelogHeading heading;
    private final ChangelogVersions versions;
    private final ChangelogArchives archives;

    public static Changelog of(List<ChangelogVersion> versions, List<ChangelogArchive> archives) {
        ChangelogHeading changelogHeading = ChangelogHeading.EMPTY;
        ChangelogVersions changelogVersions = ChangelogVersions.of(versions);
        ChangelogArchives changelogArchives = ChangelogArchives.of(archives);
        return new Changelog(changelogHeading, changelogVersions, changelogArchives);
    }

    public Changelog setUpHeading(ChangelogHeading heading) {
        return Changelog.builder().heading(heading).versions(this.versions).archives(this.archives).build();
    }

    private static ChangelogBuilder builder() {
        return new ChangelogBuilder();
    }

    public ChangelogHeading getHeading() {
        return this.heading;
    }

    public ChangelogVersions getVersions() {
        return this.versions;
    }

    public ChangelogArchives getArchives() {
        return this.archives;
    }

    private Changelog(ChangelogHeading heading, ChangelogVersions versions, ChangelogArchives archives) {
        this.heading = heading;
        this.versions = versions;
        this.archives = archives;
    }

    private static class ChangelogBuilder {
        private ChangelogHeading heading;
        private ChangelogVersions versions;
        private ChangelogArchives archives;

        ChangelogBuilder() {
        }

        private ChangelogBuilder heading(ChangelogHeading heading) {
            this.heading = heading;
            return this;
        }

        private ChangelogBuilder versions(ChangelogVersions versions) {
            this.versions = versions;
            return this;
        }

        private ChangelogBuilder archives(ChangelogArchives archives) {
            this.archives = archives;
            return this;
        }

        private Changelog build() {
            return new Changelog(this.heading, this.versions, this.archives);
        }

        public String toString() {
            return "Changelog.ChangelogBuilder(heading=" + this.heading + ", versions=" + this.versions + ", archives=" + this.archives + ")";
        }
    }
}

