/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu.chat;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import dev.langchain4j.model.zhipu.chat.Parameters;
import java.util.HashMap;

public final class Function {
    private final String name;
    private final String description;
    private final Parameters parameters;

    private Function(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.parameters = builder.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Parameters parameters() {
        return this.parameters;
    }

    public String toString() {
        return "Function(name=" + this.name + ", description=" + this.description + ", parameters=" + this.parameters + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Function)) {
            return false;
        }
        Function other = (Function)o;
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Parameters this$parameters = this.parameters;
        Parameters other$parameters = other.parameters;
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Parameters $parameters = this.parameters;
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public static final class Builder {
        private String name;
        private String description;
        private Parameters parameters;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder addParameter(String name, JsonSchemaProperty ... jsonSchemaProperties) {
            this.addOptionalParameter(name, jsonSchemaProperties);
            this.parameters.required().add(name);
            return this;
        }

        public Builder addOptionalParameter(String name, JsonSchemaProperty ... jsonSchemaProperties) {
            if (this.parameters == null) {
                this.parameters = Parameters.builder().build();
            }
            HashMap<String, Object> jsonSchemaPropertiesMap = new HashMap<String, Object>();
            for (JsonSchemaProperty jsonSchemaProperty : jsonSchemaProperties) {
                jsonSchemaPropertiesMap.put(jsonSchemaProperty.key(), jsonSchemaProperty.value());
            }
            this.parameters.properties().put(name, jsonSchemaPropertiesMap);
            return this;
        }

        public Function build() {
            return new Function(this);
        }
    }
}

