/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu.embedding;

import dev.langchain4j.model.zhipu.embedding.EmbeddingModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class EmbeddingRequest {
    private final String input;
    private final String model;

    private EmbeddingRequest(Builder builder) {
        this.model = builder.model;
        this.input = (String)builder.input.get(0);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInput() {
        return this.input;
    }

    public String getModel() {
        return this.model;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EmbeddingRequest && this.equalTo((EmbeddingRequest)another);
    }

    private boolean equalTo(EmbeddingRequest another) {
        return Objects.equals(this.model, another.model) && Objects.equals(this.input, another.input);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.model);
        h += (h << 5) + Objects.hashCode(this.input);
        return h;
    }

    public String toString() {
        return "EmbeddingRequest{model=" + this.model + ", input=" + this.input + "}";
    }

    public static final class Builder {
        private String model = EmbeddingModel.EMBEDDING_2.toString();
        private List<String> input;

        private Builder() {
        }

        public Builder model(EmbeddingModel model) {
            return this.model(model.toString());
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder input(String ... input) {
            return this.input(Arrays.asList(input));
        }

        public Builder input(List<String> input) {
            if (input == null || input.isEmpty()) {
                throw new RuntimeException();
            }
            if (input.size() > 1) {
                throw new RuntimeException();
            }
            this.input = Collections.unmodifiableList(input);
            return this;
        }

        public EmbeddingRequest build() {
            return new EmbeddingRequest(this);
        }
    }
}

