/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu.chat;

import com.google.gson.annotations.SerializedName;
import dev.langchain4j.model.zhipu.chat.AssistantMessage;
import dev.langchain4j.model.zhipu.chat.ChatCompletionModel;
import dev.langchain4j.model.zhipu.chat.Message;
import dev.langchain4j.model.zhipu.chat.SystemMessage;
import dev.langchain4j.model.zhipu.chat.Tool;
import dev.langchain4j.model.zhipu.chat.ToolChoice;
import dev.langchain4j.model.zhipu.chat.ToolChoiceMode;
import dev.langchain4j.model.zhipu.chat.ToolMessage;
import dev.langchain4j.model.zhipu.chat.UserMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ChatCompletionRequest {
    private final String model;
    private final List<Message> messages;
    @SerializedName(value="request_id")
    private final String requestId;
    @SerializedName(value="do_sample")
    private final String doSample;
    private final Boolean stream;
    private final Double temperature;
    @SerializedName(value="top_p")
    private final Double topP;
    @SerializedName(value="max_tokens")
    private final Integer maxTokens;
    private final List<String> stop;
    private final List<Tool> tools;
    @SerializedName(value="tool_choice")
    private final Object toolChoice;

    private ChatCompletionRequest(Builder builder) {
        this.model = builder.model;
        this.messages = builder.messages;
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.requestId = builder.requestId;
        this.stream = builder.stream;
        this.stop = builder.stop;
        this.maxTokens = builder.maxTokens;
        this.doSample = builder.doSample;
        this.tools = builder.tools;
        this.toolChoice = builder.toolChoice;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String model() {
        return this.model;
    }

    public List<Message> messages() {
        return this.messages;
    }

    public Double temperature() {
        return this.temperature;
    }

    public Double topP() {
        return this.topP;
    }

    public Boolean stream() {
        return this.stream;
    }

    public List<String> stop() {
        return this.stop;
    }

    public Integer maxTokens() {
        return this.maxTokens;
    }

    public List<Tool> tools() {
        return this.tools;
    }

    public Object toolChoice() {
        return this.toolChoice;
    }

    public String toString() {
        return "ChatCompletionRequest(model=" + this.model + ", messages=" + this.messages + ", requestId=" + this.requestId + ", doSample=" + this.doSample + ", stream=" + this.stream + ", temperature=" + this.temperature + ", topP=" + this.topP + ", maxTokens=" + this.maxTokens + ", stop=" + this.stop + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletionRequest)) {
            return false;
        }
        ChatCompletionRequest other = (ChatCompletionRequest)o;
        Boolean this$stream = this.stream;
        Boolean other$stream = other.stream;
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Double this$temperature = this.temperature;
        Double other$temperature = other.temperature;
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Double this$topP = this.topP;
        Double other$topP = other.topP;
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$maxTokens = this.maxTokens;
        Integer other$maxTokens = other.maxTokens;
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        String this$model = this.model;
        String other$model = other.model;
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<Message> this$messages = this.messages;
        List<Message> other$messages = other.messages;
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$requestId = this.requestId;
        String other$requestId = other.requestId;
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$doSample = this.doSample;
        String other$doSample = other.doSample;
        if (this$doSample == null ? other$doSample != null : !this$doSample.equals(other$doSample)) {
            return false;
        }
        List<String> this$stop = this.stop;
        List<String> other$stop = other.stop;
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        List<Tool> this$tools = this.tools;
        List<Tool> other$tools = other.tools;
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        Object this$toolChoice = this.toolChoice;
        Object other$toolChoice = other.toolChoice;
        return !(this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $stream = this.stream;
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Double $temperature = this.temperature;
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Double $topP = this.topP;
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $maxTokens = this.maxTokens;
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        String $model = this.model;
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<Message> $messages = this.messages;
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $requestId = this.requestId;
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $doSample = this.doSample;
        result = result * 59 + ($doSample == null ? 43 : $doSample.hashCode());
        List<String> $stop = this.stop;
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        List<Tool> $tools = this.tools;
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        Object $toolChoice = this.toolChoice;
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        return result;
    }

    public static final class Builder {
        private String model = ChatCompletionModel.GLM_4.toString();
        private List<Message> messages;
        private Double temperature;
        private Double topP;
        private String requestId;
        private Boolean stream;
        private List<String> stop;
        private Integer maxTokens;
        private String doSample;
        private List<Tool> tools;
        private Object toolChoice;

        private Builder() {
        }

        public Builder from(ChatCompletionRequest instance) {
            this.model(instance.model);
            this.messages(instance.messages);
            this.temperature(instance.temperature);
            this.topP(instance.topP);
            this.requestId(instance.requestId);
            this.stream(instance.stream);
            this.stop(instance.stop);
            this.maxTokens(instance.maxTokens);
            this.doSample(instance.doSample);
            this.tools(instance.tools);
            this.toolChoice(instance.toolChoice);
            return this;
        }

        public Builder model(ChatCompletionModel model) {
            return this.model(model.toString());
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder messages(List<Message> messages) {
            if (messages != null) {
                this.messages = Collections.unmodifiableList(messages);
            }
            return this;
        }

        public Builder messages(Message ... messages) {
            return this.messages(Arrays.asList(messages));
        }

        public Builder addSystemMessage(String systemMessage) {
            if (this.messages == null) {
                this.messages = new ArrayList<Message>();
            }
            this.messages.add(SystemMessage.from(systemMessage));
            return this;
        }

        public Builder addUserMessage(String userMessage) {
            if (this.messages == null) {
                this.messages = new ArrayList<Message>();
            }
            this.messages.add(UserMessage.from(userMessage));
            return this;
        }

        public Builder addAssistantMessage(String assistantMessage) {
            if (this.messages == null) {
                this.messages = new ArrayList<Message>();
            }
            this.messages.add(AssistantMessage.from(assistantMessage));
            return this;
        }

        public Builder addToolMessage(String toolCallId, String content) {
            if (this.messages == null) {
                this.messages = new ArrayList<Message>();
            }
            this.messages.add(ToolMessage.from(toolCallId, content));
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder stop(List<String> stop) {
            if (stop != null) {
                this.stop = Collections.unmodifiableList(stop);
            }
            return this;
        }

        public Builder stop(String ... stop) {
            return this.stop(Arrays.asList(stop));
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder doSample(String doSample) {
            this.doSample = doSample;
            return this;
        }

        public Builder tools(List<Tool> tools) {
            if (tools != null) {
                this.tools = Collections.unmodifiableList(tools);
            }
            return this;
        }

        public Builder tools(Tool ... tools) {
            return this.tools(Arrays.asList(tools));
        }

        public Builder toolChoice(ToolChoiceMode toolChoiceMode) {
            this.toolChoice = toolChoiceMode;
            return this;
        }

        public Builder toolChoice(String functionName) {
            return this.toolChoice(ToolChoice.from(functionName));
        }

        public Builder toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public ChatCompletionRequest build() {
            return new ChatCompletionRequest(this);
        }
    }
}

