/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.vearch;

import dev.langchain4j.store.embedding.vearch.ModelParam;
import dev.langchain4j.store.embedding.vearch.RetrievalParam;
import dev.langchain4j.store.embedding.vearch.RetrievalType;
import dev.langchain4j.store.embedding.vearch.SpaceEngine;
import dev.langchain4j.store.embedding.vearch.SpacePropertyParam;
import dev.langchain4j.store.embedding.vearch.SpaceStoreType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VearchConfig {
    private String databaseName;
    private String spaceName;
    private SpaceEngine spaceEngine;
    private Map<String, SpacePropertyParam> properties;
    private String embeddingFieldName;
    private String textFieldName;
    private List<ModelParam> modelParams;
    private List<String> metadataFieldNames;

    public static VearchConfig getDefaultConfig() {
        HashMap<String, SpacePropertyParam> properties = new HashMap<String, SpacePropertyParam>(4);
        properties.put("embedding", SpacePropertyParam.VectorParam.builder().index(true).storeType(SpaceStoreType.MEMORY_ONLY).dimension(384).build());
        properties.put("text", SpacePropertyParam.StringParam.builder().build());
        return VearchConfig.builder().spaceEngine(SpaceEngine.builder().name("gamma").indexSize(1L).retrievalType(RetrievalType.FLAT).retrievalParam(RetrievalParam.FLAT.builder().build()).build()).properties(properties).databaseName("embedding_db").spaceName("embedding_space").modelParams(Collections.singletonList(ModelParam.builder().modelId("vgg16").fields(Collections.singletonList("string")).out("feature").build())).build();
    }

    private static String $default$embeddingFieldName() {
        return "embedding";
    }

    private static String $default$textFieldName() {
        return "text";
    }

    VearchConfig(String databaseName, String spaceName, SpaceEngine spaceEngine, Map<String, SpacePropertyParam> properties, String embeddingFieldName, String textFieldName, List<ModelParam> modelParams, List<String> metadataFieldNames) {
        this.databaseName = databaseName;
        this.spaceName = spaceName;
        this.spaceEngine = spaceEngine;
        this.properties = properties;
        this.embeddingFieldName = embeddingFieldName;
        this.textFieldName = textFieldName;
        this.modelParams = modelParams;
        this.metadataFieldNames = metadataFieldNames;
    }

    public static VearchConfigBuilder builder() {
        return new VearchConfigBuilder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public SpaceEngine getSpaceEngine() {
        return this.spaceEngine;
    }

    public Map<String, SpacePropertyParam> getProperties() {
        return this.properties;
    }

    public String getEmbeddingFieldName() {
        return this.embeddingFieldName;
    }

    public String getTextFieldName() {
        return this.textFieldName;
    }

    public List<ModelParam> getModelParams() {
        return this.modelParams;
    }

    public List<String> getMetadataFieldNames() {
        return this.metadataFieldNames;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public void setSpaceEngine(SpaceEngine spaceEngine) {
        this.spaceEngine = spaceEngine;
    }

    public void setProperties(Map<String, SpacePropertyParam> properties) {
        this.properties = properties;
    }

    public void setEmbeddingFieldName(String embeddingFieldName) {
        this.embeddingFieldName = embeddingFieldName;
    }

    public void setTextFieldName(String textFieldName) {
        this.textFieldName = textFieldName;
    }

    public void setModelParams(List<ModelParam> modelParams) {
        this.modelParams = modelParams;
    }

    public void setMetadataFieldNames(List<String> metadataFieldNames) {
        this.metadataFieldNames = metadataFieldNames;
    }

    public static class VearchConfigBuilder {
        private String databaseName;
        private String spaceName;
        private SpaceEngine spaceEngine;
        private Map<String, SpacePropertyParam> properties;
        private boolean embeddingFieldName$set;
        private String embeddingFieldName$value;
        private boolean textFieldName$set;
        private String textFieldName$value;
        private List<ModelParam> modelParams;
        private List<String> metadataFieldNames;

        VearchConfigBuilder() {
        }

        public VearchConfigBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public VearchConfigBuilder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public VearchConfigBuilder spaceEngine(SpaceEngine spaceEngine) {
            this.spaceEngine = spaceEngine;
            return this;
        }

        public VearchConfigBuilder properties(Map<String, SpacePropertyParam> properties) {
            this.properties = properties;
            return this;
        }

        public VearchConfigBuilder embeddingFieldName(String embeddingFieldName) {
            this.embeddingFieldName$value = embeddingFieldName;
            this.embeddingFieldName$set = true;
            return this;
        }

        public VearchConfigBuilder textFieldName(String textFieldName) {
            this.textFieldName$value = textFieldName;
            this.textFieldName$set = true;
            return this;
        }

        public VearchConfigBuilder modelParams(List<ModelParam> modelParams) {
            this.modelParams = modelParams;
            return this;
        }

        public VearchConfigBuilder metadataFieldNames(List<String> metadataFieldNames) {
            this.metadataFieldNames = metadataFieldNames;
            return this;
        }

        public VearchConfig build() {
            String embeddingFieldName$value = this.embeddingFieldName$value;
            if (!this.embeddingFieldName$set) {
                embeddingFieldName$value = VearchConfig.$default$embeddingFieldName();
            }
            String textFieldName$value = this.textFieldName$value;
            if (!this.textFieldName$set) {
                textFieldName$value = VearchConfig.$default$textFieldName();
            }
            return new VearchConfig(this.databaseName, this.spaceName, this.spaceEngine, this.properties, embeddingFieldName$value, textFieldName$value, this.modelParams, this.metadataFieldNames);
        }

        public String toString() {
            return "VearchConfig.VearchConfigBuilder(databaseName=" + this.databaseName + ", spaceName=" + this.spaceName + ", spaceEngine=" + this.spaceEngine + ", properties=" + this.properties + ", embeddingFieldName$value=" + this.embeddingFieldName$value + ", textFieldName$value=" + this.textFieldName$value + ", modelParams=" + this.modelParams + ", metadataFieldNames=" + this.metadataFieldNames + ")";
        }
    }
}

