/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.vearch;

import dev.langchain4j.store.embedding.vearch.SpacePropertyType;
import dev.langchain4j.store.embedding.vearch.SpaceStoreParam;
import dev.langchain4j.store.embedding.vearch.SpaceStoreType;

public abstract class SpacePropertyParam {
    protected SpacePropertyType type;

    SpacePropertyParam(SpacePropertyType type) {
        this.type = type;
    }

    public static class VectorParam
    extends SpacePropertyParam {
        private Boolean index;
        private Integer dimension;
        private SpaceStoreType storeType;
        private SpaceStoreParam storeParam;
        private String modelId;
        private String format;

        public VectorParam() {
            super(SpacePropertyType.VECTOR);
        }

        public VectorParam(Boolean index, Integer dimension, SpaceStoreType storeType, SpaceStoreParam storeParam, String modelId, String format) {
            this();
            this.index = index;
            this.dimension = dimension;
            this.storeType = storeType;
            this.storeParam = storeParam;
            this.modelId = modelId;
            this.format = format;
        }

        public static VectorParamBuilder builder() {
            return new VectorParamBuilder();
        }

        public Boolean getIndex() {
            return this.index;
        }

        public Integer getDimension() {
            return this.dimension;
        }

        public SpaceStoreType getStoreType() {
            return this.storeType;
        }

        public SpaceStoreParam getStoreParam() {
            return this.storeParam;
        }

        public String getModelId() {
            return this.modelId;
        }

        public String getFormat() {
            return this.format;
        }

        public void setIndex(Boolean index) {
            this.index = index;
        }

        public void setDimension(Integer dimension) {
            this.dimension = dimension;
        }

        public void setStoreType(SpaceStoreType storeType) {
            this.storeType = storeType;
        }

        public void setStoreParam(SpaceStoreParam storeParam) {
            this.storeParam = storeParam;
        }

        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public static class VectorParamBuilder {
            private Boolean index;
            private Integer dimension;
            private SpaceStoreType storeType;
            private SpaceStoreParam storeParam;
            private String modelId;
            private String format;

            VectorParamBuilder() {
            }

            public VectorParamBuilder index(Boolean index) {
                this.index = index;
                return this;
            }

            public VectorParamBuilder dimension(Integer dimension) {
                this.dimension = dimension;
                return this;
            }

            public VectorParamBuilder storeType(SpaceStoreType storeType) {
                this.storeType = storeType;
                return this;
            }

            public VectorParamBuilder storeParam(SpaceStoreParam storeParam) {
                this.storeParam = storeParam;
                return this;
            }

            public VectorParamBuilder modelId(String modelId) {
                this.modelId = modelId;
                return this;
            }

            public VectorParamBuilder format(String format) {
                this.format = format;
                return this;
            }

            public VectorParam build() {
                return new VectorParam(this.index, this.dimension, this.storeType, this.storeParam, this.modelId, this.format);
            }

            public String toString() {
                return "SpacePropertyParam.VectorParam.VectorParamBuilder(index=" + this.index + ", dimension=" + this.dimension + ", storeType=" + (Object)((Object)this.storeType) + ", storeParam=" + this.storeParam + ", modelId=" + this.modelId + ", format=" + this.format + ")";
            }
        }
    }

    public static class FloatParam
    extends SpacePropertyParam {
        private Boolean index;

        public FloatParam() {
            super(SpacePropertyType.FLOAT);
        }

        public FloatParam(Boolean index) {
            this();
            this.index = index;
        }

        public static FloatParamBuilder builder() {
            return new FloatParamBuilder();
        }

        public Boolean getIndex() {
            return this.index;
        }

        public void setIndex(Boolean index) {
            this.index = index;
        }

        public static class FloatParamBuilder {
            private Boolean index;

            FloatParamBuilder() {
            }

            public FloatParamBuilder index(Boolean index) {
                this.index = index;
                return this;
            }

            public FloatParam build() {
                return new FloatParam(this.index);
            }

            public String toString() {
                return "SpacePropertyParam.FloatParam.FloatParamBuilder(index=" + this.index + ")";
            }
        }
    }

    public static class IntegerParam
    extends SpacePropertyParam {
        private Boolean index;

        public IntegerParam() {
            super(SpacePropertyType.INTEGER);
        }

        public IntegerParam(Boolean index) {
            this();
            this.index = index;
        }

        public static IntegerParamBuilder builder() {
            return new IntegerParamBuilder();
        }

        public Boolean getIndex() {
            return this.index;
        }

        public void setIndex(Boolean index) {
            this.index = index;
        }

        public static class IntegerParamBuilder {
            private Boolean index;

            IntegerParamBuilder() {
            }

            public IntegerParamBuilder index(Boolean index) {
                this.index = index;
                return this;
            }

            public IntegerParam build() {
                return new IntegerParam(this.index);
            }

            public String toString() {
                return "SpacePropertyParam.IntegerParam.IntegerParamBuilder(index=" + this.index + ")";
            }
        }
    }

    public static class StringParam
    extends SpacePropertyParam {
        private Boolean index;
        private Boolean array;

        public StringParam() {
            super(SpacePropertyType.STRING);
        }

        public StringParam(Boolean index, Boolean array) {
            this();
            this.index = index;
            this.array = array;
        }

        public static StringParamBuilder builder() {
            return new StringParamBuilder();
        }

        public Boolean getIndex() {
            return this.index;
        }

        public Boolean getArray() {
            return this.array;
        }

        public void setIndex(Boolean index) {
            this.index = index;
        }

        public void setArray(Boolean array) {
            this.array = array;
        }

        public static class StringParamBuilder {
            private Boolean index;
            private Boolean array;

            StringParamBuilder() {
            }

            public StringParamBuilder index(Boolean index) {
                this.index = index;
                return this;
            }

            public StringParamBuilder array(Boolean array) {
                this.array = array;
                return this;
            }

            public StringParam build() {
                return new StringParam(this.index, this.array);
            }

            public String toString() {
                return "SpacePropertyParam.StringParam.StringParamBuilder(index=" + this.index + ", array=" + this.array + ")";
            }
        }
    }
}

