/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.vearch;

import dev.langchain4j.store.embedding.vearch.RetrievalParam;
import dev.langchain4j.store.embedding.vearch.RetrievalType;

public class SpaceEngine {
    private String name;
    private Long indexSize;
    private RetrievalType retrievalType;
    private RetrievalParam retrievalParam;

    public SpaceEngine() {
    }

    public SpaceEngine(String name, Long indexSize, RetrievalType retrievalType, RetrievalParam retrievalParam) {
        this.setName(name);
        this.setIndexSize(indexSize);
        this.setRetrievalType(retrievalType);
        this.setRetrievalParam(retrievalParam);
    }

    public void setRetrievalParam(RetrievalParam retrievalParam) {
        Class<? extends RetrievalParam> clazz = this.retrievalType.getParamClass();
        if (!clazz.isInstance(retrievalParam)) {
            throw new UnsupportedOperationException(String.format("can't assign unknown param of engine %s, please use class %s to assign engine param", this.retrievalType.name(), clazz.getSimpleName()));
        }
        this.retrievalParam = retrievalParam;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public Long getIndexSize() {
        return this.indexSize;
    }

    public RetrievalType getRetrievalType() {
        return this.retrievalType;
    }

    public RetrievalParam getRetrievalParam() {
        return this.retrievalParam;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIndexSize(Long indexSize) {
        this.indexSize = indexSize;
    }

    public void setRetrievalType(RetrievalType retrievalType) {
        this.retrievalType = retrievalType;
    }

    public static class Builder {
        private String name;
        private Long indexSize;
        private RetrievalType retrievalType;
        private RetrievalParam retrievalParam;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder indexSize(Long indexSize) {
            this.indexSize = indexSize;
            return this;
        }

        public Builder retrievalType(RetrievalType retrievalType) {
            this.retrievalType = retrievalType;
            return this;
        }

        public Builder retrievalParam(RetrievalParam retrievalParam) {
            this.retrievalParam = retrievalParam;
            return this;
        }

        public SpaceEngine build() {
            return new SpaceEngine(this.name, this.indexSize, this.retrievalType, this.retrievalParam);
        }
    }
}

