/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.vearch;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

class SearchResponse {
    private Integer took;
    @SerializedName(value="timed_out")
    private Boolean timeout;
    @SerializedName(value="_shards")
    private Object shards;
    private Hit hits;

    SearchResponse(Integer took, Boolean timeout, Object shards, Hit hits) {
        this.took = took;
        this.timeout = timeout;
        this.shards = shards;
        this.hits = hits;
    }

    public static SearchResponseBuilder builder() {
        return new SearchResponseBuilder();
    }

    public Integer getTook() {
        return this.took;
    }

    public Boolean getTimeout() {
        return this.timeout;
    }

    public Object getShards() {
        return this.shards;
    }

    public Hit getHits() {
        return this.hits;
    }

    public void setTook(Integer took) {
        this.took = took;
    }

    public void setTimeout(Boolean timeout) {
        this.timeout = timeout;
    }

    public void setShards(Object shards) {
        this.shards = shards;
    }

    public void setHits(Hit hits) {
        this.hits = hits;
    }

    public static class Hit {
        private Integer total;
        private Double maxScore;
        private List<SearchedDocument> hits;

        Hit(Integer total, Double maxScore, List<SearchedDocument> hits) {
            this.total = total;
            this.maxScore = maxScore;
            this.hits = hits;
        }

        public static HitBuilder builder() {
            return new HitBuilder();
        }

        public Integer getTotal() {
            return this.total;
        }

        public Double getMaxScore() {
            return this.maxScore;
        }

        public List<SearchedDocument> getHits() {
            return this.hits;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public void setMaxScore(Double maxScore) {
            this.maxScore = maxScore;
        }

        public void setHits(List<SearchedDocument> hits) {
            this.hits = hits;
        }

        public static class HitBuilder {
            private Integer total;
            private Double maxScore;
            private List<SearchedDocument> hits;

            HitBuilder() {
            }

            public HitBuilder total(Integer total) {
                this.total = total;
                return this;
            }

            public HitBuilder maxScore(Double maxScore) {
                this.maxScore = maxScore;
                return this;
            }

            public HitBuilder hits(List<SearchedDocument> hits) {
                this.hits = hits;
                return this;
            }

            public Hit build() {
                return new Hit(this.total, this.maxScore, this.hits);
            }

            public String toString() {
                return "SearchResponse.Hit.HitBuilder(total=" + this.total + ", maxScore=" + this.maxScore + ", hits=" + this.hits + ")";
            }
        }
    }

    public static class SearchResponseBuilder {
        private Integer took;
        private Boolean timeout;
        private Object shards;
        private Hit hits;

        SearchResponseBuilder() {
        }

        public SearchResponseBuilder took(Integer took) {
            this.took = took;
            return this;
        }

        public SearchResponseBuilder timeout(Boolean timeout) {
            this.timeout = timeout;
            return this;
        }

        public SearchResponseBuilder shards(Object shards) {
            this.shards = shards;
            return this;
        }

        public SearchResponseBuilder hits(Hit hits) {
            this.hits = hits;
            return this;
        }

        public SearchResponse build() {
            return new SearchResponse(this.took, this.timeout, this.shards, this.hits);
        }

        public String toString() {
            return "SearchResponse.SearchResponseBuilder(took=" + this.took + ", timeout=" + this.timeout + ", shards=" + this.shards + ", hits=" + this.hits + ")";
        }
    }

    public static class SearchedDocument {
        @SerializedName(value="_id")
        private String id;
        @SerializedName(value="_score")
        private Double score;
        @SerializedName(value="_source")
        private Map<String, Object> source;

        SearchedDocument(String id, Double score, Map<String, Object> source) {
            this.id = id;
            this.score = score;
            this.source = source;
        }

        public static SearchedDocumentBuilder builder() {
            return new SearchedDocumentBuilder();
        }

        public String getId() {
            return this.id;
        }

        public Double getScore() {
            return this.score;
        }

        public Map<String, Object> getSource() {
            return this.source;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setScore(Double score) {
            this.score = score;
        }

        public void setSource(Map<String, Object> source) {
            this.source = source;
        }

        public static class SearchedDocumentBuilder {
            private String id;
            private Double score;
            private Map<String, Object> source;

            SearchedDocumentBuilder() {
            }

            public SearchedDocumentBuilder id(String id) {
                this.id = id;
                return this;
            }

            public SearchedDocumentBuilder score(Double score) {
                this.score = score;
                return this;
            }

            public SearchedDocumentBuilder source(Map<String, Object> source) {
                this.source = source;
                return this;
            }

            public SearchedDocument build() {
                return new SearchedDocument(this.id, this.score, this.source);
            }

            public String toString() {
                return "SearchResponse.SearchedDocument.SearchedDocumentBuilder(id=" + this.id + ", score=" + this.score + ", source=" + this.source + ")";
            }
        }
    }
}

