/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.vearch;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.CosineSimilarity;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.RelevanceScore;
import dev.langchain4j.store.embedding.vearch.BulkRequest;
import dev.langchain4j.store.embedding.vearch.CreateDatabaseRequest;
import dev.langchain4j.store.embedding.vearch.CreateSpaceRequest;
import dev.langchain4j.store.embedding.vearch.ListDatabaseResponse;
import dev.langchain4j.store.embedding.vearch.ListSpaceResponse;
import dev.langchain4j.store.embedding.vearch.SearchRequest;
import dev.langchain4j.store.embedding.vearch.SearchResponse;
import dev.langchain4j.store.embedding.vearch.VearchClient;
import dev.langchain4j.store.embedding.vearch.VearchConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class VearchEmbeddingStore
implements EmbeddingStore<TextSegment> {
    private final VearchConfig vearchConfig;
    private final VearchClient vearchClient;
    private final boolean normalizeEmbeddings;

    public VearchEmbeddingStore(String baseUrl, Duration timeout, VearchConfig vearchConfig, Boolean normalizeEmbeddings) {
        baseUrl = (String)ValidationUtils.ensureNotNull((Object)baseUrl, (String)"baseUrl");
        this.vearchConfig = (VearchConfig)Utils.getOrDefault((Object)vearchConfig, (Object)VearchConfig.getDefaultConfig());
        this.normalizeEmbeddings = (Boolean)Utils.getOrDefault((Object)normalizeEmbeddings, (Object)false);
        this.vearchClient = VearchClient.builder().baseUrl(baseUrl).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).build();
        if (!this.isDatabaseExist(this.vearchConfig.getDatabaseName())) {
            this.createDatabase(this.vearchConfig.getDatabaseName());
        }
        if (!this.isSpaceExist(this.vearchConfig.getDatabaseName(), this.vearchConfig.getSpaceName())) {
            this.createSpace(this.vearchConfig.getDatabaseName(), this.vearchConfig.getSpaceName());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String add(Embedding embedding) {
        String id = Utils.randomUUID();
        this.add(id, embedding);
        return id;
    }

    public void add(String id, Embedding embedding) {
        this.addInternal(id, embedding, null);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        String id = Utils.randomUUID();
        this.addInternal(id, embedding, textSegment);
        return id;
    }

    public List<String> addAll(List<Embedding> embeddings) {
        List<String> ids = embeddings.stream().map(ignored -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, null);
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> embedded) {
        List<String> ids = embeddings.stream().map(ignored -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, embedded);
        return ids;
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults, double minScore) {
        double minSimilarity = CosineSimilarity.fromRelevanceScore((double)minScore);
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList(this.vearchConfig.getTextFieldName(), this.vearchConfig.getEmbeddingFieldName()));
        fields.addAll(this.vearchConfig.getMetadataFieldNames());
        SearchRequest request = SearchRequest.builder().query(SearchRequest.QueryParam.builder().sum(Collections.singletonList(SearchRequest.VectorParam.builder().field(this.vearchConfig.getEmbeddingFieldName()).feature(referenceEmbedding.vectorAsList()).minScore(minSimilarity).build())).build()).size(maxResults).fields(fields).build();
        SearchResponse response = this.vearchClient.search(this.vearchConfig.getDatabaseName(), this.vearchConfig.getSpaceName(), request);
        return this.toEmbeddingMatch(response.getHits());
    }

    public void deleteSpace() {
        this.vearchClient.deleteSpace(this.vearchConfig.getDatabaseName(), this.vearchConfig.getSpaceName());
    }

    private void addInternal(String id, Embedding embedding, TextSegment embedded) {
        this.addAllInternal(Collections.singletonList(id), Collections.singletonList(embedding), embedded == null ? null : Collections.singletonList(embedded));
    }

    private void addAllInternal(List<String> ids, List<Embedding> embeddings, List<TextSegment> embedded) {
        ids = (List)ValidationUtils.ensureNotEmpty(ids, (String)"ids");
        embeddings = (List)ValidationUtils.ensureNotEmpty(embeddings, (String)"embeddings");
        ValidationUtils.ensureTrue((ids.size() == embeddings.size() ? 1 : 0) != 0, (String)"ids size is not equal to embeddings size");
        ValidationUtils.ensureTrue((embedded == null || embeddings.size() == embedded.size() ? 1 : 0) != 0, (String)"embeddings size is not equal to embedded size");
        ArrayList<Map<String, Object>> documents = new ArrayList<Map<String, Object>>(ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            HashMap<String, Object> document = new HashMap<String, Object>(4);
            document.put("_id", ids.get(i));
            HashMap<String, List> embeddingValue = new HashMap<String, List>(1);
            Embedding embedding = (Embedding)embeddings.get(i);
            if (this.normalizeEmbeddings) {
                embedding.normalize();
            }
            embeddingValue.put("feature", embedding.vectorAsList());
            document.put(this.vearchConfig.getEmbeddingFieldName(), embeddingValue);
            if (embedded != null) {
                document.put(this.vearchConfig.getTextFieldName(), embedded.get(i).text());
                Map metadata = embedded.get(i).metadata().asMap();
                for (String metadataFieldName : this.vearchConfig.getMetadataFieldNames()) {
                    metadata.putIfAbsent(metadataFieldName, "");
                }
                document.putAll(metadata);
            } else {
                document.put(this.vearchConfig.getTextFieldName(), "");
                if (!Utils.isNullOrEmpty(this.vearchConfig.getMetadataFieldNames())) {
                    for (String metadataFieldName : this.vearchConfig.getMetadataFieldNames()) {
                        document.put(metadataFieldName, "");
                    }
                }
            }
            documents.add(document);
        }
        BulkRequest request = BulkRequest.builder().documents(documents).build();
        this.vearchClient.bulk(this.vearchConfig.getDatabaseName(), this.vearchConfig.getSpaceName(), request);
    }

    private boolean isDatabaseExist(String databaseName) {
        List<ListDatabaseResponse> databases = this.vearchClient.listDatabase();
        return databases.stream().anyMatch(database -> databaseName.equals(database.getName()));
    }

    private void createDatabase(String databaseName) {
        this.vearchClient.createDatabase(CreateDatabaseRequest.builder().name(databaseName).build());
    }

    private boolean isSpaceExist(String databaseName, String spaceName) {
        List<ListSpaceResponse> spaces = this.vearchClient.listSpace(databaseName);
        return spaces.stream().anyMatch(space -> spaceName.equals(space.getName()));
    }

    private void createSpace(String databaseName, String space) {
        this.vearchClient.createSpace(databaseName, CreateSpaceRequest.builder().name(space).engine(this.vearchConfig.getSpaceEngine()).replicaNum(1).partitionNum(1).properties(this.vearchConfig.getProperties()).models(this.vearchConfig.getModelParams()).build());
    }

    private List<EmbeddingMatch<TextSegment>> toEmbeddingMatch(SearchResponse.Hit hit) {
        List<SearchResponse.SearchedDocument> searchedDocuments = hit.getHits();
        if (Utils.isNullOrEmpty(searchedDocuments)) {
            return new ArrayList<EmbeddingMatch<TextSegment>>();
        }
        return searchedDocuments.stream().map(searchedDocument -> {
            String text;
            Map<String, Object> source = searchedDocument.getSource();
            String id = searchedDocument.getId();
            List vector = (List)((Map)source.get(this.vearchConfig.getEmbeddingFieldName())).get("feature");
            Embedding embedding = Embedding.from(vector.stream().map(Double::floatValue).collect(Collectors.toList()));
            TextSegment textSegment = null;
            String string = text = source.get(this.vearchConfig.getTextFieldName()) == null ? null : String.valueOf(source.get(this.vearchConfig.getTextFieldName()));
            if (!Utils.isNullOrBlank(text)) {
                Map<String, String> metadataMap = this.convertMetadataMap(source);
                textSegment = TextSegment.from((String)text, (Metadata)Metadata.from(metadataMap));
            }
            return new EmbeddingMatch(Double.valueOf(RelevanceScore.fromCosineSimilarity((double)searchedDocument.getScore())), id, embedding, (Object)textSegment);
        }).collect(Collectors.toList());
    }

    private Map<String, String> convertMetadataMap(Map<String, Object> source) {
        source.remove(this.vearchConfig.getTextFieldName());
        source.remove(this.vearchConfig.getEmbeddingFieldName());
        if (source.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> metadataMap = new HashMap<String, String>(source.size());
        source.forEach((key, value) -> {
            if (!Utils.isNullOrBlank((String)String.valueOf(value))) {
                metadataMap.put((String)key, String.valueOf(value));
            }
        });
        return metadataMap;
    }

    public static class Builder {
        private VearchConfig vearchConfig;
        private String baseUrl;
        private Duration timeout;
        private Boolean normalizeEmbeddings;

        public Builder vearchConfig(VearchConfig vearchConfig) {
            this.vearchConfig = vearchConfig;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder normalizeEmbeddings(Boolean normalizeEmbeddings) {
            this.normalizeEmbeddings = normalizeEmbeddings;
            return this;
        }

        public VearchEmbeddingStore build() {
            return new VearchEmbeddingStore(this.baseUrl, this.timeout, this.vearchConfig, this.normalizeEmbeddings);
        }
    }
}

