/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.vearch;

import java.util.List;

class SearchRequest {
    private QueryParam query;
    private Integer size;
    private List<String> fields;

    SearchRequest(QueryParam query, Integer size, List<String> fields) {
        this.query = query;
        this.size = size;
        this.fields = fields;
    }

    public static SearchRequestBuilder builder() {
        return new SearchRequestBuilder();
    }

    public QueryParam getQuery() {
        return this.query;
    }

    public Integer getSize() {
        return this.size;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setQuery(QueryParam query) {
        this.query = query;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public static class QueryParam {
        private List<VectorParam> sum;

        QueryParam(List<VectorParam> sum) {
            this.sum = sum;
        }

        public static QueryParamBuilder builder() {
            return new QueryParamBuilder();
        }

        public List<VectorParam> getSum() {
            return this.sum;
        }

        public void setSum(List<VectorParam> sum) {
            this.sum = sum;
        }

        public static class QueryParamBuilder {
            private List<VectorParam> sum;

            QueryParamBuilder() {
            }

            public QueryParamBuilder sum(List<VectorParam> sum) {
                this.sum = sum;
                return this;
            }

            public QueryParam build() {
                return new QueryParam(this.sum);
            }

            public String toString() {
                return "SearchRequest.QueryParam.QueryParamBuilder(sum=" + this.sum + ")";
            }
        }
    }

    public static class SearchRequestBuilder {
        private QueryParam query;
        private Integer size;
        private List<String> fields;

        SearchRequestBuilder() {
        }

        public SearchRequestBuilder query(QueryParam query) {
            this.query = query;
            return this;
        }

        public SearchRequestBuilder size(Integer size) {
            this.size = size;
            return this;
        }

        public SearchRequestBuilder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public SearchRequest build() {
            return new SearchRequest(this.query, this.size, this.fields);
        }

        public String toString() {
            return "SearchRequest.SearchRequestBuilder(query=" + this.query + ", size=" + this.size + ", fields=" + this.fields + ")";
        }
    }

    public static class VectorParam {
        private String field;
        private List<Float> feature;
        private Double minScore;

        VectorParam(String field, List<Float> feature, Double minScore) {
            this.field = field;
            this.feature = feature;
            this.minScore = minScore;
        }

        public static VectorParamBuilder builder() {
            return new VectorParamBuilder();
        }

        public String getField() {
            return this.field;
        }

        public List<Float> getFeature() {
            return this.feature;
        }

        public Double getMinScore() {
            return this.minScore;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setFeature(List<Float> feature) {
            this.feature = feature;
        }

        public void setMinScore(Double minScore) {
            this.minScore = minScore;
        }

        public static class VectorParamBuilder {
            private String field;
            private List<Float> feature;
            private Double minScore;

            VectorParamBuilder() {
            }

            public VectorParamBuilder field(String field) {
                this.field = field;
                return this;
            }

            public VectorParamBuilder feature(List<Float> feature) {
                this.feature = feature;
                return this;
            }

            public VectorParamBuilder minScore(Double minScore) {
                this.minScore = minScore;
                return this;
            }

            public VectorParam build() {
                return new VectorParam(this.field, this.feature, this.minScore);
            }

            public String toString() {
                return "SearchRequest.VectorParam.VectorParamBuilder(field=" + this.field + ", feature=" + this.feature + ", minScore=" + this.minScore + ")";
            }
        }
    }
}

