/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.vearch;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.langchain4j.store.embedding.vearch.BulkRequest;
import dev.langchain4j.store.embedding.vearch.CreateDatabaseRequest;
import dev.langchain4j.store.embedding.vearch.CreateDatabaseResponse;
import dev.langchain4j.store.embedding.vearch.CreateSpaceRequest;
import dev.langchain4j.store.embedding.vearch.CreateSpaceResponse;
import dev.langchain4j.store.embedding.vearch.ListDatabaseResponse;
import dev.langchain4j.store.embedding.vearch.ListSpaceResponse;
import dev.langchain4j.store.embedding.vearch.ResponseWrapper;
import dev.langchain4j.store.embedding.vearch.SearchRequest;
import dev.langchain4j.store.embedding.vearch.SearchResponse;
import dev.langchain4j.store.embedding.vearch.VearchApi;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class VearchClient {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private final VearchApi vearchApi;

    public VearchClient(String baseUrl, Duration timeout) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)GSON)).build();
        this.vearchApi = (VearchApi)retrofit.create(VearchApi.class);
    }

    public List<ListDatabaseResponse> listDatabase() {
        try {
            Response response = this.vearchApi.listDatabase().execute();
            if (response.isSuccessful() && response.body() != null) {
                ResponseWrapper wrapper = (ResponseWrapper)response.body();
                if (wrapper.getCode() != 200) {
                    throw this.toException(wrapper);
                }
                return (List)wrapper.getData();
            }
            throw this.toException(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CreateDatabaseResponse createDatabase(CreateDatabaseRequest request) {
        try {
            Response response = this.vearchApi.createDatabase(request).execute();
            if (response.isSuccessful() && response.body() != null) {
                ResponseWrapper wrapper = (ResponseWrapper)response.body();
                if (wrapper.getCode() != 200) {
                    throw this.toException(wrapper);
                }
                return (CreateDatabaseResponse)wrapper.getData();
            }
            throw this.toException(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ListSpaceResponse> listSpace(String dbName) {
        try {
            Response response = this.vearchApi.listSpaceOfDatabase(dbName).execute();
            if (response.isSuccessful() && response.body() != null) {
                ResponseWrapper wrapper = (ResponseWrapper)response.body();
                if (wrapper.getCode() != 200) {
                    throw this.toException(wrapper);
                }
                return (List)wrapper.getData();
            }
            throw this.toException(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CreateSpaceResponse createSpace(String dbName, CreateSpaceRequest request) {
        try {
            Response response = this.vearchApi.createSpace(dbName, request).execute();
            if (response.isSuccessful() && response.body() != null) {
                ResponseWrapper wrapper = (ResponseWrapper)response.body();
                if (wrapper.getCode() != 200) {
                    throw this.toException(wrapper);
                }
                return (CreateSpaceResponse)wrapper.getData();
            }
            throw this.toException(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void bulk(String dbName, String spaceName, BulkRequest request) {
        try {
            StringBuilder bodyString = new StringBuilder();
            for (Map<String, Object> document : request.getDocuments()) {
                HashMap<String, Object> fieldsExceptId = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : document.entrySet()) {
                    String fieldName = entry.getKey();
                    Object value = entry.getValue();
                    if ("_id".equals(fieldName)) {
                        bodyString.append("{\"index\": {\"_id\": \"").append(value).append("\"}}\n");
                        continue;
                    }
                    fieldsExceptId.put(fieldName, value);
                }
                bodyString.append(GSON.toJson(fieldsExceptId)).append("\n");
            }
            RequestBody body = RequestBody.create((String)bodyString.toString(), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
            Response response = this.vearchApi.bulk(dbName, spaceName, body).execute();
            if (!response.isSuccessful() || response.body() == null) {
                throw this.toException(response);
            }
            List bulkResponses = (List)response.body();
            bulkResponses.forEach(bulkResponse -> {
                if (bulkResponse.getStatus() != 200) {
                    throw this.toException(bulkResponse.getStatus(), bulkResponse.getError());
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SearchResponse search(String dbName, String spaceName, SearchRequest request) {
        try {
            Response response = this.vearchApi.search(dbName, spaceName, request).execute();
            if (response.isSuccessful() && response.body() != null) {
                SearchResponse searchResponse = (SearchResponse)response.body();
                if (Boolean.TRUE.equals(searchResponse.getTimeout())) {
                    throw new RuntimeException("Search Timeout");
                }
                return searchResponse;
            }
            throw this.toException(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteSpace(String databaseName, String spaceName) {
        try {
            Response response = this.vearchApi.deleteSpace(databaseName, spaceName).execute();
            if (!response.isSuccessful()) {
                throw this.toException(response);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    private RuntimeException toException(ResponseWrapper<?> responseWrapper) {
        return this.toException(responseWrapper.getCode(), responseWrapper.getMsg());
    }

    private RuntimeException toException(int code, String msg) {
        String errorMessage = String.format("code: %s; message: %s", code, msg);
        return new RuntimeException(errorMessage);
    }

    public static VearchClientBuilder builder() {
        return new VearchClientBuilder();
    }

    public static class VearchClientBuilder {
        private String baseUrl;
        private Duration timeout;

        VearchClientBuilder() {
        }

        public VearchClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public VearchClientBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public VearchClient build() {
            return new VearchClient(this.baseUrl, this.timeout);
        }

        public String toString() {
            return "VearchClient.VearchClientBuilder(baseUrl=" + this.baseUrl + ", timeout=" + this.timeout + ")";
        }
    }
}

