/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.language.StreamingLanguageModel;
import dev.langchain4j.model.ollama.CompletionRequest;
import dev.langchain4j.model.ollama.OllamaClient;
import dev.langchain4j.model.ollama.OllamaMessagesUtils;
import dev.langchain4j.model.ollama.Options;
import dev.langchain4j.model.ollama.spi.OllamaStreamingLanguageModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OllamaStreamingLanguageModel
implements StreamingLanguageModel {
    private final OllamaClient client;
    private final String modelName;
    private final Options options;
    private final ResponseFormat responseFormat;

    public OllamaStreamingLanguageModel(String baseUrl, String modelName, Double temperature, Integer topK, Double topP, Double repeatPenalty, Integer seed, Integer numPredict, Integer numCtx, List<String> stop, String format, ResponseFormat responseFormat, Duration timeout, Boolean logRequests, Boolean logResponses, Map<String, String> customHeaders) {
        if (format != null && responseFormat != null) {
            throw new IllegalStateException("Cant use both 'format' and 'responseFormat' parameters");
        }
        this.client = OllamaClient.builder().baseUrl(baseUrl).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).logRequests(logRequests).logStreamingResponses(logResponses).customHeaders(customHeaders).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.options = Options.builder().temperature(temperature).topK(topK).topP(topP).repeatPenalty(repeatPenalty).seed(seed).numPredict(numPredict).numCtx(numCtx).stop(stop).build();
        this.responseFormat = "json".equals(format) ? ResponseFormat.JSON : responseFormat;
    }

    public static OllamaStreamingLanguageModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(OllamaStreamingLanguageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OllamaStreamingLanguageModelBuilderFactory factory = (OllamaStreamingLanguageModelBuilderFactory)iterator.next();
            return (OllamaStreamingLanguageModelBuilder)factory.get();
        }
        return new OllamaStreamingLanguageModelBuilder();
    }

    public void generate(String prompt, StreamingResponseHandler<String> handler) {
        CompletionRequest request = CompletionRequest.builder().model(this.modelName).prompt(prompt).options(this.options).format(OllamaMessagesUtils.toOllamaResponseFormat(this.responseFormat)).stream(true).build();
        this.client.streamingCompletion(request, handler);
    }

    public static class OllamaStreamingLanguageModelBuilder {
        private String baseUrl;
        private String modelName;
        private Double temperature;
        private Integer topK;
        private Double topP;
        private Double repeatPenalty;
        private Integer seed;
        private Integer numPredict;
        private Integer numCtx;
        private List<String> stop;
        private String format;
        private ResponseFormat responseFormat;
        private Duration timeout;
        private Map<String, String> customHeaders;
        private Boolean logRequests;
        private Boolean logResponses;

        public OllamaStreamingLanguageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder repeatPenalty(Double repeatPenalty) {
            this.repeatPenalty = repeatPenalty;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder numPredict(Integer numPredict) {
            this.numPredict = numPredict;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder numCtx(Integer numCtx) {
            this.numCtx = numCtx;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @Deprecated
        public OllamaStreamingLanguageModelBuilder format(String format) {
            this.format = format;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OllamaStreamingLanguageModel build() {
            return new OllamaStreamingLanguageModel(this.baseUrl, this.modelName, this.temperature, this.topK, this.topP, this.repeatPenalty, this.seed, this.numPredict, this.numCtx, this.stop, this.format, this.responseFormat, this.timeout, this.logRequests, this.logResponses, this.customHeaders);
        }
    }
}

