/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ollama.DeleteModelRequest;
import dev.langchain4j.model.ollama.ModelsListResponse;
import dev.langchain4j.model.ollama.OllamaClient;
import dev.langchain4j.model.ollama.OllamaModel;
import dev.langchain4j.model.ollama.OllamaModelCard;
import dev.langchain4j.model.ollama.RunningModelsListResponse;
import dev.langchain4j.model.ollama.RunningOllamaModel;
import dev.langchain4j.model.ollama.ShowModelInformationRequest;
import dev.langchain4j.model.output.Response;
import java.time.Duration;
import java.util.List;

public class OllamaModels {
    private final OllamaClient client;
    private final Integer maxRetries;

    public OllamaModels(String baseUrl, Duration timeout, Integer maxRetries, Boolean logRequests, Boolean logResponses) {
        this.client = OllamaClient.builder().baseUrl(baseUrl).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).logRequests(logRequests).logResponses(logResponses).build();
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public static OllamaModelsBuilder builder() {
        return new OllamaModelsBuilder();
    }

    public Response<List<OllamaModel>> availableModels() {
        ModelsListResponse response = (ModelsListResponse)RetryUtils.withRetry(this.client::listModels, (int)this.maxRetries);
        return Response.from(response.getModels());
    }

    public Response<OllamaModelCard> modelCard(OllamaModel ollamaModel) {
        return this.modelCard(ollamaModel.getName());
    }

    public Response<OllamaModelCard> modelCard(String modelName) {
        OllamaModelCard response = (OllamaModelCard)RetryUtils.withRetry(() -> this.client.showInformation(ShowModelInformationRequest.builder().name(modelName).build()), (int)this.maxRetries);
        return Response.from((Object)response);
    }

    public void deleteModel(OllamaModel ollamaModel) {
        this.deleteModel(ollamaModel.getName());
    }

    public void deleteModel(String ollamaModelName) {
        RetryUtils.withRetry(() -> this.client.deleteModel(DeleteModelRequest.builder().name(ollamaModelName).build()), (int)this.maxRetries);
    }

    public Response<List<RunningOllamaModel>> runningModels() {
        RunningModelsListResponse response = (RunningModelsListResponse)RetryUtils.withRetry(this.client::listRunningModels, (int)this.maxRetries);
        return Response.from(response.getModels());
    }

    public static class OllamaModelsBuilder {
        private String baseUrl;
        private Duration timeout;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;

        public OllamaModelsBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OllamaModelsBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OllamaModelsBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OllamaModelsBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OllamaModelsBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OllamaModels build() {
            return new OllamaModels(this.baseUrl, this.timeout, this.maxRetries, this.logRequests, this.logResponses);
        }
    }
}

