/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.DimensionAwareEmbeddingModel;
import dev.langchain4j.model.ollama.EmbeddingRequest;
import dev.langchain4j.model.ollama.EmbeddingResponse;
import dev.langchain4j.model.ollama.OllamaClient;
import dev.langchain4j.model.ollama.spi.OllamaEmbeddingModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OllamaEmbeddingModel
extends DimensionAwareEmbeddingModel {
    private final OllamaClient client;
    private final String modelName;
    private final Integer maxRetries;

    public OllamaEmbeddingModel(String baseUrl, String modelName, Duration timeout, Integer maxRetries, Boolean logRequests, Boolean logResponses, Map<String, String> customHeaders) {
        this.client = OllamaClient.builder().baseUrl(baseUrl).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).logRequests(logRequests).logResponses(logResponses).customHeaders(customHeaders).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List<String> input = textSegments.stream().map(TextSegment::text).collect(Collectors.toList());
        EmbeddingRequest request = EmbeddingRequest.builder().model(this.modelName).input(input).build();
        EmbeddingResponse response = (EmbeddingResponse)RetryUtils.withRetry(() -> this.client.embed(request), (int)this.maxRetries);
        List embeddings = response.getEmbeddings().stream().map(Embedding::from).collect(Collectors.toList());
        return Response.from(embeddings);
    }

    public static OllamaEmbeddingModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(OllamaEmbeddingModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OllamaEmbeddingModelBuilderFactory factory = (OllamaEmbeddingModelBuilderFactory)iterator.next();
            return (OllamaEmbeddingModelBuilder)factory.get();
        }
        return new OllamaEmbeddingModelBuilder();
    }

    public static class OllamaEmbeddingModelBuilder {
        private String baseUrl;
        private String modelName;
        private Duration timeout;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;
        private Map<String, String> customHeaders;

        public OllamaEmbeddingModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OllamaEmbeddingModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OllamaEmbeddingModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OllamaEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OllamaEmbeddingModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OllamaEmbeddingModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OllamaEmbeddingModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OllamaEmbeddingModel build() {
            return new OllamaEmbeddingModel(this.baseUrl, this.modelName, this.timeout, this.maxRetries, this.logRequests, this.logResponses, this.customHeaders);
        }

        public String toString() {
            return "OllamaEmbeddingModel.OllamaEmbeddingModelBuilder(baseUrl=" + this.baseUrl + ", modelName=" + this.modelName + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", customHeaders=" + this.customHeaders + ")";
        }
    }
}

