/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.ollama.ChatRequest;
import dev.langchain4j.model.ollama.ChatResponse;
import dev.langchain4j.model.ollama.CompletionRequest;
import dev.langchain4j.model.ollama.CompletionResponse;
import dev.langchain4j.model.ollama.EmbeddingRequest;
import dev.langchain4j.model.ollama.EmbeddingResponse;
import dev.langchain4j.model.ollama.OllamaApi;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class OllamaClient {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private final OllamaApi ollamaApi;

    public OllamaClient(String baseUrl, Duration timeout) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)GSON)).build();
        this.ollamaApi = (OllamaApi)retrofit.create(OllamaApi.class);
    }

    public CompletionResponse completion(CompletionRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.completion(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (CompletionResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ChatResponse chat(ChatRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.chat(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (ChatResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void streamingCompletion(CompletionRequest request, final StreamingResponseHandler<String> handler) {
        this.ollamaApi.streamingCompletion(request).enqueue((Callback)new Callback<ResponseBody>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> retrofitResponse) {
                try (InputStream inputStream = ((ResponseBody)retrofitResponse.body()).byteStream();){
                    StringBuilder contentBuilder = new StringBuilder();
                    while (true) {
                        byte[] bytes = new byte[1024];
                        int len = inputStream.read(bytes);
                        String partialResponse = new String(bytes, 0, len);
                        CompletionResponse completionResponse = (CompletionResponse)GSON.fromJson(partialResponse, CompletionResponse.class);
                        contentBuilder.append(completionResponse.getResponse());
                        handler.onNext(completionResponse.getResponse());
                        if (Boolean.TRUE.equals(completionResponse.getDone())) {
                            Response response = Response.from((Object)contentBuilder.toString(), (TokenUsage)new TokenUsage(completionResponse.getPromptEvalCount(), completionResponse.getEvalCount()));
                            handler.onComplete(response);
                            return;
                        }
                        continue;
                        break;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                handler.onError(throwable);
            }
        });
    }

    public void streamingChat(ChatRequest request, final StreamingResponseHandler<AiMessage> handler) {
        this.ollamaApi.streamingChat(request).enqueue((Callback)new Callback<ResponseBody>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> retrofitResponse) {
                try (InputStream inputStream = ((ResponseBody)retrofitResponse.body()).byteStream();){
                    StringBuilder contentBuilder = new StringBuilder();
                    while (true) {
                        byte[] bytes = new byte[1024];
                        int len = inputStream.read(bytes);
                        String partialResponse = new String(bytes, 0, len);
                        ChatResponse chatResponse = (ChatResponse)GSON.fromJson(partialResponse, ChatResponse.class);
                        String content = chatResponse.getMessage().getContent();
                        contentBuilder.append(content);
                        handler.onNext(content);
                        if (Boolean.TRUE.equals(chatResponse.getDone())) {
                            Response response = Response.from((Object)AiMessage.from((String)contentBuilder.toString()), (TokenUsage)new TokenUsage(chatResponse.getPromptEvalCount(), chatResponse.getEvalCount()));
                            handler.onComplete(response);
                            return;
                        }
                        continue;
                        break;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                handler.onError(throwable);
            }
        });
    }

    public EmbeddingResponse embed(EmbeddingRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.embedd(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (EmbeddingResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RuntimeException toException(retrofit2.Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    public static OllamaClientBuilder builder() {
        return new OllamaClientBuilder();
    }

    public static class OllamaClientBuilder {
        private String baseUrl;
        private Duration timeout;

        OllamaClientBuilder() {
        }

        public OllamaClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OllamaClientBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OllamaClient build() {
            return new OllamaClient(this.baseUrl, this.timeout);
        }

        public String toString() {
            return "OllamaClient.OllamaClientBuilder(baseUrl=" + this.baseUrl + ", timeout=" + this.timeout + ")";
        }
    }
}

