/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.graph.neo4j;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.graph.neo4j.Neo4jException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.MapAccessor;

public class Neo4jGraph
implements AutoCloseable {
    private static final String NODE_PROPERTIES_QUERY = "CALL apoc.meta.data()\nYIELD label, other, elementType, type, property\nWHERE NOT type = \"RELATIONSHIP\" AND elementType = \"node\"\nWITH label AS nodeLabels, collect({property:property, type:type}) AS properties\nRETURN {labels: nodeLabels, properties: properties} AS output\n";
    private static final String REL_PROPERTIES_QUERY = "CALL apoc.meta.data()\nYIELD label, other, elementType, type, property\nWHERE NOT type = \"RELATIONSHIP\" AND elementType = \"relationship\"\nWITH label AS nodeLabels, collect({property:property, type:type}) AS properties\nRETURN {type: nodeLabels, properties: properties} AS output\n";
    private static final String RELATIONSHIPS_QUERY = "CALL apoc.meta.data()\nYIELD label, other, elementType, type, property\nWHERE type = \"RELATIONSHIP\" AND elementType = \"node\"\nUNWIND other AS other_node\nRETURN {start: label, type: property, end: toString(other_node)} AS output\n";
    private final Driver driver;
    private String schema;

    public Neo4jGraph(Driver driver) {
        this.driver = (Driver)ValidationUtils.ensureNotNull((Object)driver, (String)"driver");
        this.driver.verifyConnectivity();
        try {
            this.refreshSchema();
        }
        catch (ClientException e) {
            if ("Neo.ClientError.Procedure.ProcedureNotFound".equals(e.code())) {
                throw new Neo4jException("Please ensure the APOC plugin is installed in Neo4j", e);
            }
            throw e;
        }
    }

    public ResultSummary executeWrite(String queryString) {
        ResultSummary resultSummary;
        block8: {
            Session session = this.driver.session();
            try {
                resultSummary = (ResultSummary)session.executeWrite(tx -> tx.run(queryString).consume());
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClientException e) {
                    throw new Neo4jException("Error executing query: " + queryString, e);
                }
            }
            session.close();
        }
        return resultSummary;
    }

    public List<Record> executeRead(String queryString) {
        List list;
        block8: {
            Session session = this.driver.session();
            try {
                list = (List)session.executeRead(tx -> {
                    Query query = new Query(queryString);
                    Result result = tx.run(query);
                    return result.list();
                });
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClientException e) {
                    throw new Neo4jException("Error executing query: " + queryString, e);
                }
            }
            session.close();
        }
        return list;
    }

    public void refreshSchema() {
        List<String> nodeProperties = this.formatNodeProperties(this.executeRead(NODE_PROPERTIES_QUERY));
        List<String> relationshipProperties = this.formatRelationshipProperties(this.executeRead(REL_PROPERTIES_QUERY));
        List<String> relationships = this.formatRelationships(this.executeRead(RELATIONSHIPS_QUERY));
        this.schema = "Node properties are the following:\n" + String.join((CharSequence)"\n", nodeProperties) + "\n\nRelationship properties are the following:\n" + String.join((CharSequence)"\n", relationshipProperties) + "\n\nThe relationships are the following:\n" + String.join((CharSequence)"\n", relationships);
    }

    private List<String> formatNodeProperties(List<Record> records) {
        return records.stream().map(this::getOutput).map(r -> String.format("%s %s", r.asMap().get("labels"), this.formatMap(r.get("properties").asList(MapAccessor::asMap)))).toList();
    }

    private List<String> formatRelationshipProperties(List<Record> records) {
        return records.stream().map(this::getOutput).map(r -> String.format("%s %s", r.get("type"), this.formatMap(r.get("properties").asList(MapAccessor::asMap)))).toList();
    }

    private List<String> formatRelationships(List<Record> records) {
        return records.stream().map(r -> this.getOutput((Record)r).asMap()).map(r -> String.format("(:%s)-[:%s]->(:%s)", r.get("start"), r.get("type"), r.get("end"))).toList();
    }

    private Value getOutput(Record record) {
        return record.get("output");
    }

    private String formatMap(List<Map<String, Object>> properties) {
        return properties.stream().map(prop -> String.valueOf(prop.get("property")) + ":" + String.valueOf(prop.get("type"))).collect(Collectors.joining(", ", "{", "}"));
    }

    @Override
    public void close() {
        this.driver.close();
    }

    public static Neo4jGraphBuilder builder() {
        return new Neo4jGraphBuilder();
    }

    public String getSchema() {
        return this.schema;
    }

    public static class Neo4jGraphBuilder {
        private Driver driver;

        Neo4jGraphBuilder() {
        }

        public Neo4jGraphBuilder driver(Driver driver) {
            this.driver = driver;
            return this;
        }

        public Neo4jGraph build() {
            return new Neo4jGraph(this.driver);
        }

        public String toString() {
            return "Neo4jGraph.Neo4jGraphBuilder(driver=" + String.valueOf(this.driver) + ")";
        }
    }
}

