/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.neo4j;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.neo4j.Neo4jEmbeddingStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.cypherdsl.support.schema_name.SchemaNames;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;

class Neo4jEmbeddingUtils {
    public static final String EMBEDDINGS_ROW_KEY = "embeddingRow";
    public static final String DEFAULT_ID_PROP = "id";
    public static final String DEFAULT_DATABASE_NAME = "neo4j";
    public static final String DEFAULT_EMBEDDING_PROP = "embedding";
    public static final String PROPS = "props";
    public static final String DEFAULT_IDX_NAME = "vector";
    public static final String DEFAULT_LABEL = "Document";
    public static final String DEFAULT_TEXT_PROP = "text";
    public static final long DEFAULT_AWAIT_INDEX_TIMEOUT = 60L;

    Neo4jEmbeddingUtils() {
    }

    public static EmbeddingMatch<TextSegment> toEmbeddingMatch(Neo4jEmbeddingStore store, Record neo4jRecord) {
        HashMap metaData = new HashMap();
        neo4jRecord.get("metadata").asMap().forEach((key, value) -> {
            if (!store.getNotMetaKeys().contains(key)) {
                String stringValue = value == null ? null : value.toString();
                metaData.put(key.replace(store.getMetadataPrefix(), ""), stringValue);
            }
        });
        Metadata metadata = new Metadata(metaData);
        Value text = neo4jRecord.get(store.getTextProperty());
        TextSegment textSegment = text.isNull() ? null : TextSegment.from((String)text.asString(), (Metadata)metadata);
        List embeddingList = neo4jRecord.get(store.getEmbeddingProperty()).asList(Value::asFloat);
        Embedding embedding = Embedding.from((List)embeddingList);
        return new EmbeddingMatch(Double.valueOf(neo4jRecord.get("score").asDouble()), neo4jRecord.get(store.getIdProperty()).asString(), embedding, (Object)textSegment);
    }

    public static Map<String, Object> toRecord(Neo4jEmbeddingStore store, int idx, List<String> ids, List<Embedding> embeddings, List<TextSegment> embedded) {
        String id = ids.get(idx);
        Embedding embedding = embeddings.get(idx);
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put(store.getIdProperty(), id);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (embedded != null) {
            TextSegment segment = embedded.get(idx);
            properties.put(store.getTextProperty(), segment.text());
            Map metadata = segment.metadata().asMap();
            metadata.forEach((k, v) -> properties.put(store.getMetadataPrefix() + k, (String)Values.value((String)v)));
        }
        row.put(EMBEDDINGS_ROW_KEY, Values.value((float[])embedding.vector()));
        row.put(PROPS, properties);
        return row;
    }

    public static Stream<List<Map<String, Object>>> getRowsBatched(Neo4jEmbeddingStore store, List<String> ids, List<Embedding> embeddings, List<TextSegment> embedded) {
        int batchSize = 10000;
        AtomicInteger batchCounter = new AtomicInteger();
        int total = ids.size();
        int batchNumber = (int)Math.ceil((double)total / (double)batchSize);
        return IntStream.range(0, batchNumber).mapToObj(part -> {
            List<Map> maps = ids.subList(Math.min(part * batchSize, total), Math.min((part + 1) * batchSize, total)).stream().map(i -> Neo4jEmbeddingUtils.toRecord(store, batchCounter.getAndIncrement(), ids, embeddings, embedded)).toList();
            return maps;
        });
    }

    public static String sanitizeOrThrows(String value, String config) {
        return (String)SchemaNames.sanitize((String)value).orElseThrow(() -> {
            String invalidSanitizeValue = String.format("The value %s, to assign to configuration %s, cannot be safely quoted", value, config);
            return new RuntimeException(invalidSanitizeValue);
        });
    }
}

