/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.mongodb;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.SearchPath;
import com.mongodb.client.model.search.VectorSearchOptions;
import com.mongodb.client.result.InsertManyResult;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.mongodb.IndexMapping;
import dev.langchain4j.store.embedding.mongodb.MappingUtils;
import dev.langchain4j.store.embedding.mongodb.MongoDbDocument;
import dev.langchain4j.store.embedding.mongodb.MongoDbMatchedDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbEmbeddingStore
implements EmbeddingStore<TextSegment> {
    private static final Logger log = LoggerFactory.getLogger(MongoDbEmbeddingStore.class);
    private final MongoCollection<MongoDbDocument> collection;
    private final String indexName;
    private final long maxResultRatio;
    private final VectorSearchOptions vectorSearchOptions;

    public MongoDbEmbeddingStore(MongoClient mongoClient, String databaseName, String collectionName, String indexName, Long maxResultRatio, CreateCollectionOptions createCollectionOptions, Bson filter, IndexMapping indexMapping, Boolean createIndex) {
        databaseName = (String)ValidationUtils.ensureNotNull((Object)databaseName, (String)"databaseName");
        collectionName = (String)ValidationUtils.ensureNotNull((Object)collectionName, (String)"collectionName");
        createIndex = (Boolean)Utils.getOrDefault((Object)createIndex, (Object)false);
        this.indexName = (String)ValidationUtils.ensureNotNull((Object)indexName, (String)"indexName");
        this.maxResultRatio = (Long)Utils.getOrDefault((Object)maxResultRatio, (Object)10L);
        CodecRegistry pojoCodecRegistry = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().register(new Class[]{MongoDbDocument.class, MongoDbMatchedDocument.class}).build()});
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), pojoCodecRegistry});
        MongoDatabase database = mongoClient.getDatabase(databaseName);
        if (!this.isCollectionExist(database, collectionName)) {
            this.createCollection(database, collectionName, (CreateCollectionOptions)Utils.getOrDefault((Object)createCollectionOptions, (Object)new CreateCollectionOptions()));
        }
        this.collection = database.getCollection(collectionName, MongoDbDocument.class).withCodecRegistry(codecRegistry);
        VectorSearchOptions vectorSearchOptions = this.vectorSearchOptions = filter == null ? VectorSearchOptions.vectorSearchOptions() : VectorSearchOptions.vectorSearchOptions().filter(filter);
        if (Boolean.TRUE.equals(createIndex) && !this.isIndexExist(this.indexName)) {
            this.createIndex(this.indexName, (IndexMapping)Utils.getOrDefault((Object)indexMapping, (Object)IndexMapping.defaultIndexMapping()));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String add(Embedding embedding) {
        String id = Utils.randomUUID();
        this.add(id, embedding);
        return id;
    }

    public void add(String id, Embedding embedding) {
        this.addInternal(id, embedding, null);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        String id = Utils.randomUUID();
        this.addInternal(id, embedding, textSegment);
        return id;
    }

    public List<String> addAll(List<Embedding> embeddings) {
        List<String> ids = embeddings.stream().map(ignored -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, null);
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> embedded) {
        List<String> ids = embeddings.stream().map(ignored -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, embedded);
        return ids;
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults, double minScore) {
        List queryVector = referenceEmbedding.vectorAsList().stream().map(Float::doubleValue).collect(Collectors.toList());
        long numCandidates = (long)maxResults * this.maxResultRatio;
        List<Bson> pipeline = Arrays.asList(Aggregates.vectorSearch((FieldSearchPath)SearchPath.fieldPath((String)"embedding"), queryVector, (String)this.indexName, (long)numCandidates, (long)maxResults, (VectorSearchOptions)this.vectorSearchOptions), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{Projections.metaVectorSearchScore((String)"score"), Projections.include((String[])new String[]{"embedding", "metadata", "text"})})), Aggregates.match((Bson)Filters.gte((String)"score", (Object)minScore)));
        try {
            AggregateIterable results = this.collection.aggregate(pipeline, MongoDbMatchedDocument.class);
            return StreamSupport.stream(results.spliterator(), false).map(MappingUtils::toEmbeddingMatch).collect(Collectors.toList());
        }
        catch (MongoCommandException e) {
            if (log.isErrorEnabled()) {
                log.error("Error in MongoDBEmbeddingStore.findRelevant", (Throwable)e);
            }
            throw new RuntimeException(e);
        }
    }

    private void addInternal(String id, Embedding embedding, TextSegment embedded) {
        this.addAllInternal(Collections.singletonList(id), Collections.singletonList(embedding), embedded == null ? null : Collections.singletonList(embedded));
    }

    private void addAllInternal(List<String> ids, List<Embedding> embeddings, List<TextSegment> embedded) {
        if (Utils.isNullOrEmpty(ids) || Utils.isNullOrEmpty(embeddings)) {
            log.info("do not add empty embeddings to MongoDB Atlas");
            return;
        }
        ValidationUtils.ensureTrue((ids.size() == embeddings.size() ? 1 : 0) != 0, (String)"ids size is not equal to embeddings size");
        ValidationUtils.ensureTrue((embedded == null || embeddings.size() == embedded.size() ? 1 : 0) != 0, (String)"embeddings size is not equal to embedded size");
        ArrayList<MongoDbDocument> documents = new ArrayList<MongoDbDocument>(ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            MongoDbDocument document = MappingUtils.toMongoDbDocument(ids.get(i), embeddings.get(i), embedded == null ? null : embedded.get(i));
            documents.add(document);
        }
        InsertManyResult result = this.collection.insertMany(documents);
        if (!result.wasAcknowledged() && log.isWarnEnabled()) {
            String errMsg = String.format("[MongoDbEmbeddingStore] Add document failed, Document=%s", documents);
            log.warn(errMsg);
            throw new RuntimeException(errMsg);
        }
    }

    private boolean isCollectionExist(MongoDatabase database, String collectionName) {
        return StreamSupport.stream(database.listCollectionNames().spliterator(), false).anyMatch(collectionName::equals);
    }

    private void createCollection(MongoDatabase database, String collectionName, CreateCollectionOptions createCollectionOptions) {
        database.createCollection(collectionName, createCollectionOptions);
    }

    private boolean isIndexExist(String indexName) {
        return StreamSupport.stream(this.collection.listSearchIndexes().spliterator(), false).anyMatch(index -> indexName.equals(index.getString((Object)"name")));
    }

    private void createIndex(String indexName, IndexMapping indexMapping) {
        Document index = MappingUtils.fromIndexMapping(indexMapping);
        this.collection.createSearchIndex(indexName, (Bson)index);
    }

    public static class Builder {
        private MongoClient mongoClient;
        private String databaseName;
        private String collectionName;
        private String indexName;
        private Long maxResultRatio;
        private CreateCollectionOptions createCollectionOptions;
        private Bson filter;
        private IndexMapping indexMapping;
        private Boolean createIndex;

        public Builder fromClient(MongoClient mongoClient) {
            this.mongoClient = mongoClient;
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder maxResultRatio(Long maxResultRatio) {
            this.maxResultRatio = maxResultRatio;
            return this;
        }

        public Builder createCollectionOptions(CreateCollectionOptions createCollectionOptions) {
            this.createCollectionOptions = createCollectionOptions;
            return this;
        }

        public Builder filter(Bson filter) {
            this.filter = filter;
            return this;
        }

        public Builder indexMapping(IndexMapping indexMapping) {
            this.indexMapping = indexMapping;
            return this;
        }

        public Builder createIndex(Boolean createIndex) {
            this.createIndex = createIndex;
            return this;
        }

        public MongoDbEmbeddingStore build() {
            return new MongoDbEmbeddingStore(this.mongoClient, this.databaseName, this.collectionName, this.indexName, this.maxResultRatio, this.createCollectionOptions, this.filter, this.indexMapping, this.createIndex);
        }
    }
}

