/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.mongodb;

import java.util.HashSet;
import java.util.Set;

public class IndexMapping {
    private int dimension;
    private Set<String> metadataFieldNames;

    public static IndexMapping defaultIndexMapping() {
        return IndexMapping.builder().dimension(1536).metadataFieldNames(new HashSet<String>()).build();
    }

    public static IndexMappingBuilder builder() {
        return new IndexMappingBuilder();
    }

    public int getDimension() {
        return this.dimension;
    }

    public Set<String> getMetadataFieldNames() {
        return this.metadataFieldNames;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setMetadataFieldNames(Set<String> metadataFieldNames) {
        this.metadataFieldNames = metadataFieldNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexMapping)) {
            return false;
        }
        IndexMapping other = (IndexMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        Set<String> this$metadataFieldNames = this.getMetadataFieldNames();
        Set<String> other$metadataFieldNames = other.getMetadataFieldNames();
        return !(this$metadataFieldNames == null ? other$metadataFieldNames != null : !((Object)this$metadataFieldNames).equals(other$metadataFieldNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDimension();
        Set<String> $metadataFieldNames = this.getMetadataFieldNames();
        result = result * 59 + ($metadataFieldNames == null ? 43 : ((Object)$metadataFieldNames).hashCode());
        return result;
    }

    public String toString() {
        return "IndexMapping(dimension=" + this.getDimension() + ", metadataFieldNames=" + this.getMetadataFieldNames() + ")";
    }

    public IndexMapping() {
    }

    public IndexMapping(int dimension, Set<String> metadataFieldNames) {
        this.dimension = dimension;
        this.metadataFieldNames = metadataFieldNames;
    }

    public static class IndexMappingBuilder {
        private int dimension;
        private Set<String> metadataFieldNames;

        IndexMappingBuilder() {
        }

        public IndexMappingBuilder dimension(int dimension) {
            this.dimension = dimension;
            return this;
        }

        public IndexMappingBuilder metadataFieldNames(Set<String> metadataFieldNames) {
            this.metadataFieldNames = metadataFieldNames;
            return this;
        }

        public IndexMapping build() {
            return new IndexMapping(this.dimension, this.metadataFieldNames);
        }

        public String toString() {
            return "IndexMapping.IndexMappingBuilder(dimension=" + this.dimension + ", metadataFieldNames=" + this.metadataFieldNames + ")";
        }
    }
}

