/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.CollectionOperationsExecutor;
import dev.langchain4j.store.embedding.CollectionRequestBuilder;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.Generator;
import dev.langchain4j.store.embedding.Mapper;
import dev.langchain4j.store.embedding.milvus.MilvusCollectionDescription;
import dev.langchain4j.store.embedding.milvus.MilvusOperationsParams;
import io.milvus.client.MilvusServiceClient;
import io.milvus.param.ConnectParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.response.SearchResultsWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MilvusEmbeddingStoreImpl
implements EmbeddingStore<TextSegment> {
    private MilvusServiceClient milvusClient;
    private MilvusCollectionDescription collectionDescription;
    private MilvusOperationsParams operationsParams;

    public MilvusEmbeddingStoreImpl(String host, int port, String databaseName, String uri, String token, boolean secure, String username, String password, MilvusCollectionDescription collectionDescription, MilvusOperationsParams operationsParams) {
        ConnectParam connectParam = ConnectParam.newBuilder().withHost(host).withPort(port).withDatabaseName(databaseName).withUri(uri).withToken(token).secure(secure).withAuthorization(username, password).build();
        this.milvusClient = new MilvusServiceClient(connectParam);
        ValidationUtils.ensureNotNull((Object)collectionDescription, (String)"MilvusCollectionDescription");
        this.collectionDescription = collectionDescription;
        ValidationUtils.ensureNotNull((Object)operationsParams, (String)"MilvusOperationsParams");
        this.operationsParams = operationsParams;
    }

    public String add(Embedding embedding) {
        String id = Utils.randomUUID();
        this.add(id, embedding);
        return id;
    }

    public void add(String id, Embedding embedding) {
        this.addInternal(id, embedding, null);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        String id = Utils.randomUUID();
        this.addInternal(id, embedding, textSegment);
        return id;
    }

    public List<String> addAll(List<Embedding> embeddings) {
        List<String> ids = Generator.generateRandomIds(embeddings.size());
        this.addAllInternal(ids, embeddings, null);
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> embedded) {
        List<String> ids = Generator.generateRandomIds(embeddings.size());
        this.addAllInternal(ids, embeddings, embedded);
        return ids;
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults) {
        return this.findRelevant(referenceEmbedding, maxResults, 0.0);
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults, double minSimilarity) {
        CollectionOperationsExecutor.loadCollectionInMemory(this.milvusClient, this.collectionDescription.collectionName());
        SearchParam searchRequest = CollectionRequestBuilder.buildSearchRequest(referenceEmbedding.vectorAsList(), maxResults, this.collectionDescription, this.operationsParams);
        SearchResultsWrapper resultsWrapper = CollectionOperationsExecutor.search(this.milvusClient, searchRequest);
        return Mapper.toEmbeddingMatches(this.milvusClient, resultsWrapper, this.collectionDescription, this.operationsParams, minSimilarity);
    }

    private void addInternal(String id, Embedding embedding, TextSegment textSegment) {
        this.addAllInternal(Collections.singletonList(id), Collections.singletonList(embedding), textSegment == null ? null : Collections.singletonList(textSegment));
    }

    private void addAllInternal(List<String> ids, List<Embedding> embeddings, List<TextSegment> textSegments) {
        ArrayList<InsertParam.Field> fields = new ArrayList<InsertParam.Field>();
        fields.add(new InsertParam.Field(this.collectionDescription.idFieldName(), ids));
        fields.add(new InsertParam.Field(this.collectionDescription.vectorFieldName(), Mapper.toVectors(embeddings)));
        fields.add(new InsertParam.Field(this.collectionDescription.scalarFieldName(), Mapper.toScalars(textSegments, ids.size())));
        CollectionOperationsExecutor.insert(this.milvusClient, fields, this.collectionDescription.collectionName());
        CollectionOperationsExecutor.flush(this.milvusClient, this.collectionDescription.collectionName());
    }
}

