/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.store.embedding.CollectionRequestBuilder;
import dev.langchain4j.store.embedding.RequestToMilvusFailedException;
import dev.langchain4j.store.embedding.milvus.MilvusCollectionDescription;
import io.milvus.client.MilvusServiceClient;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.SearchResults;
import io.milvus.param.R;
import io.milvus.param.collection.FlushParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.response.QueryResultsWrapper;
import io.milvus.response.SearchResultsWrapper;
import java.util.List;

class CollectionOperationsExecutor {
    CollectionOperationsExecutor() {
    }

    public static void flush(MilvusServiceClient milvusClient, String collectionName) {
        FlushParam request = CollectionRequestBuilder.buildFlushRequest(collectionName);
        R response = milvusClient.flush(request);
        CollectionOperationsExecutor.checkResponseNotFailed(response);
    }

    public static void insert(MilvusServiceClient milvusClient, List<InsertParam.Field> fields, String collectionName) {
        InsertParam request = CollectionRequestBuilder.buildInsertRequest(fields, collectionName);
        R response = milvusClient.insert(request);
        CollectionOperationsExecutor.checkResponseNotFailed(response);
    }

    public static void loadCollectionInMemory(MilvusServiceClient milvusClient, String collectionName) {
        LoadCollectionParam request = CollectionRequestBuilder.buildLoadCollectionInMemoryRequest(collectionName);
        R response = milvusClient.loadCollection(request);
        CollectionOperationsExecutor.checkResponseNotFailed(response);
    }

    public static SearchResultsWrapper search(MilvusServiceClient milvusClient, SearchParam searchRequest) {
        R response = milvusClient.search(searchRequest);
        CollectionOperationsExecutor.checkResponseNotFailed(response);
        return new SearchResultsWrapper(((SearchResults)response.getData()).getResults());
    }

    public static QueryResultsWrapper queryForVectors(MilvusServiceClient milvusClient, MilvusCollectionDescription collectionDescription, List<String> rowIds, String consistencyLevel) {
        QueryParam request = CollectionRequestBuilder.buildQueryRequest(rowIds, collectionDescription, consistencyLevel);
        R response = milvusClient.query(request);
        CollectionOperationsExecutor.checkResponseNotFailed(response);
        return new QueryResultsWrapper((QueryResults)response.getData());
    }

    private static <T> void checkResponseNotFailed(R<T> response) {
        if (response == null) {
            throw new RequestToMilvusFailedException("Request to Milvus DB failed. Response is null");
        }
        if (response.getStatus().intValue() != R.Status.Success.getCode()) {
            String message = String.format("Request to Milvus DB failed. Response status:'%d'.%n", response.getStatus());
            throw new RequestToMilvusFailedException(message, response.getException());
        }
    }
}

