/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.parser.apache.poi;

import dev.langchain4j.data.document.BlankDocumentException;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.internal.Utils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.EmptyFileException;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.extractor.POITextExtractor;

public class ApachePoiDocumentParser
implements DocumentParser {
    public Document parse(InputStream inputStream) {
        Document document;
        block10: {
            POITextExtractor extractor = ExtractorFactory.createExtractor((InputStream)inputStream);
            try {
                String text = extractor.getText();
                if (Utils.isNullOrBlank((String)text)) {
                    throw new BlankDocumentException();
                }
                document = Document.from((String)text);
                if (extractor == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (extractor != null) {
                        try {
                            extractor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (EmptyFileException e) {
                    throw new BlankDocumentException();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            extractor.close();
        }
        return document;
    }
}

