/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.GenerationUsage;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationUsage;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.dashscope.QwenHelper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;

public class QwenStreamingResponseBuilder {
    private final StringBuilder generatedContent = new StringBuilder();
    private Integer inputTokenCount;
    private Integer outputTokenCount;
    private FinishReason finishReason;

    public String append(GenerationResult partialResponse) {
        FinishReason finishReason;
        if (partialResponse == null) {
            return null;
        }
        GenerationUsage usage = partialResponse.getUsage();
        if (usage != null) {
            this.inputTokenCount = usage.getInputTokens();
            this.outputTokenCount = usage.getOutputTokens();
        }
        if ((finishReason = QwenHelper.finishReasonFrom(partialResponse)) != null) {
            this.finishReason = finishReason;
            return null;
        }
        String partialContent = QwenHelper.answerFrom(partialResponse);
        this.generatedContent.append(partialContent);
        return partialContent;
    }

    public String append(MultiModalConversationResult partialResponse) {
        FinishReason finishReason;
        if (partialResponse == null) {
            return null;
        }
        MultiModalConversationUsage usage = partialResponse.getUsage();
        if (usage != null) {
            this.inputTokenCount = usage.getInputTokens();
            this.outputTokenCount = usage.getOutputTokens();
        }
        if ((finishReason = QwenHelper.finishReasonFrom(partialResponse)) != null) {
            this.finishReason = finishReason;
            return null;
        }
        String partialContent = QwenHelper.answerFrom(partialResponse);
        this.generatedContent.append(partialContent);
        return partialContent;
    }

    public Response<AiMessage> build() {
        return Response.from((Object)AiMessage.from((String)this.generatedContent.toString()), (TokenUsage)new TokenUsage(this.inputTokenCount, this.outputTokenCount), (FinishReason)this.finishReason);
    }
}

