/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.spi.FileTypeDetector;

public class EnhancedFileTypeDetector
extends FileTypeDetector {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String probeContentType(Path path) {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, StandardOpenOption.READ));){
            String string = URLConnection.guessContentTypeFromStream(in);
            return string;
        }
        catch (IOException e) {
            return URLConnection.guessContentTypeFromName(path.getFileName().toString());
        }
    }
}

