/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.models.QwenParam;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.dashscope.QwenChatModel;
import dev.langchain4j.model.dashscope.QwenParamHelper;
import java.util.List;

public class QwenStreamingChatModel
extends QwenChatModel
implements StreamingChatLanguageModel {
    protected QwenStreamingChatModel(String apiKey, String modelName, Double topP, Double topK, Boolean enableSearch, Integer seed) {
        super(apiKey, modelName, topP, topK, enableSearch, seed);
    }

    public void sendMessages(List<ChatMessage> messages, StreamingResponseHandler handler) {
        this.sendMessage(QwenParamHelper.toQwenPrompt(messages), handler);
    }

    protected void sendMessage(String prompt, final StreamingResponseHandler handler) {
        QwenParam param = ((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)QwenParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).prompt(prompt)).build();
        try {
            this.gen.call((HalfDuplexServiceParam)param, (ResultCallback)new ResultCallback<GenerationResult>(){

                public void onEvent(GenerationResult result) {
                    handler.onNext(result.getOutput().getText());
                }

                public void onComplete() {
                    handler.onComplete();
                }

                public void onError(Exception e) {
                    handler.onError((Throwable)e);
                }
            });
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendMessages(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler handler) {
        throw new IllegalArgumentException("Tools are currently not supported for qwen models");
    }

    public void sendMessages(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler handler) {
        throw new IllegalArgumentException("Tools are currently not supported for qwen models");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends QwenChatModel.Builder {
        @Override
        public Builder apiKey(String apiKey) {
            return (Builder)super.apiKey(apiKey);
        }

        @Override
        public Builder modelName(String modelName) {
            return (Builder)super.modelName(modelName);
        }

        @Override
        public Builder topP(Double topP) {
            return (Builder)super.topP(topP);
        }

        @Override
        public Builder topK(Double topK) {
            return (Builder)super.topK(topK);
        }

        @Override
        public Builder enableSearch(Boolean enableSearch) {
            return (Builder)super.enableSearch(enableSearch);
        }

        @Override
        public Builder seed(Integer seed) {
            return (Builder)super.seed(seed);
        }

        @Override
        public QwenStreamingChatModel build() {
            this.ensureOptions();
            return new QwenStreamingChatModel(this.apiKey, this.modelName, this.topP, this.topK, this.enableSearch, this.seed);
        }
    }
}

