/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.embeddings.TextEmbedding;
import com.alibaba.dashscope.embeddings.TextEmbeddingOutput;
import com.alibaba.dashscope.embeddings.TextEmbeddingParam;
import com.alibaba.dashscope.embeddings.TextEmbeddingResult;
import com.alibaba.dashscope.embeddings.TextEmbeddingResultItem;
import com.alibaba.dashscope.exception.NoApiKeyException;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class QwenEmbeddingModel
implements EmbeddingModel {
    public static final String TYPE_KEY = "type";
    public static final String TYPE_QUERY = "query";
    public static final String TYPE_DOCUMENT = "document";
    private final String apiKey;
    private final String modelName;
    private final TextEmbedding embedding;

    protected QwenEmbeddingModel(String apiKey, String modelName) {
        this.apiKey = apiKey;
        this.modelName = modelName;
        this.embedding = new TextEmbedding();
    }

    private boolean containsDocuments(List<TextSegment> textSegments) {
        return textSegments.stream().map(TextSegment::metadata).map(metadata -> metadata.get(TYPE_KEY)).filter(TYPE_DOCUMENT::equalsIgnoreCase).anyMatch(Utils::isNullOrBlank);
    }

    private boolean containsQueries(List<TextSegment> textSegments) {
        return textSegments.stream().map(TextSegment::metadata).map(metadata -> metadata.get(TYPE_KEY)).filter(TYPE_QUERY::equalsIgnoreCase).anyMatch(Utils::isNullOrBlank);
    }

    private List<Embedding> embedTexts(List<TextSegment> textSegments, TextEmbeddingParam.TextType textType) {
        TextEmbeddingParam param = ((TextEmbeddingParam.TextEmbeddingParamBuilder)((TextEmbeddingParam.TextEmbeddingParamBuilder)TextEmbeddingParam.builder().apiKey(this.apiKey)).model(this.modelName)).textType(textType).texts((Collection)textSegments.stream().map(TextSegment::text).collect(Collectors.toList())).build();
        try {
            return Optional.of(this.embedding.call(param)).map(TextEmbeddingResult::getOutput).map(TextEmbeddingOutput::getEmbeddings).orElse(Collections.emptyList()).stream().map(TextEmbeddingResultItem::getEmbedding).map(doubleList -> doubleList.stream().map(Double::floatValue).collect(Collectors.toList())).map(Embedding::from).collect(Collectors.toList());
        }
        catch (NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Embedding> embedAll(List<TextSegment> textSegments) {
        boolean queries = this.containsQueries(textSegments);
        if (!queries) {
            return this.embedTexts(textSegments, TextEmbeddingParam.TextType.DOCUMENT);
        }
        boolean documents = this.containsDocuments(textSegments);
        if (!documents) {
            return this.embedTexts(textSegments, TextEmbeddingParam.TextType.QUERY);
        }
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>(textSegments.size());
        for (TextSegment textSegment : textSegments) {
            List<Embedding> result = TYPE_QUERY.equalsIgnoreCase(textSegment.metadata().get(TYPE_KEY)) ? this.embedTexts(Collections.singletonList(textSegment), TextEmbeddingParam.TextType.QUERY) : this.embedTexts(Collections.singletonList(textSegment), TextEmbeddingParam.TextType.DOCUMENT);
            embeddings.addAll(result);
        }
        return embeddings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String apiKey;
        private String modelName;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        protected void ensureOptions() {
            if (Utils.isNullOrBlank((String)this.apiKey)) {
                throw new IllegalArgumentException("DashScope api key must be defined. It can be generated here: https://dashscope.console.aliyun.com/apiKey");
            }
            this.modelName = Utils.isNullOrBlank((String)this.modelName) ? "text-embedding-v1" : this.modelName;
        }

        public QwenEmbeddingModel build() {
            this.ensureOptions();
            return new QwenEmbeddingModel(this.apiKey, this.modelName);
        }
    }
}

