/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import dev.langchain4j.data.document.Metadata;
import java.util.Objects;

public class DocumentSegment {
    private final String text;
    private final Metadata metadata;

    public DocumentSegment(String text, Metadata metadata) {
        this.text = text;
        this.metadata = metadata;
    }

    public String text() {
        return this.text;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentSegment that = (DocumentSegment)o;
        return Objects.equals(this.text, that.text) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.metadata);
    }

    public String toString() {
        return "DocumentSegment { text = \"" + this.text + "\" metadata = \"" + this.metadata + "\" }";
    }

    public static DocumentSegment from(String text) {
        return new DocumentSegment(text, new Metadata());
    }

    public static DocumentSegment from(String text, Metadata metadata) {
        return new DocumentSegment(text, metadata);
    }

    public static DocumentSegment documentSegment(String text) {
        return DocumentSegment.from(text);
    }

    public static DocumentSegment documentSegment(String text, Metadata metadata) {
        return DocumentSegment.from(text, metadata);
    }
}

