/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class EmbeddingStoreTest
implements WithAssertions {
    EmbeddingStoreTest() {
    }

    @Test
    public void test() {
        MinimalEmbeddingStore store = new MinimalEmbeddingStore();
        Embedding referenceEmbedding = new Embedding(new float[]{0.5f, 1.5f});
        this.assertThat(store.findRelevant(referenceEmbedding, 12)).contains((Object[])new EmbeddingMatch[]{new EmbeddingMatch(Double.valueOf(0.5), "id", referenceEmbedding, (Object)"[0.5, 1.5], 12, 0.00")});
        this.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> store.findRelevant("MemoryId", referenceEmbedding, 12)).withMessage("Not implemented");
    }

    @Test
    public void test_memoryId() {
        MemoryIdEmbeddingStore store = new MemoryIdEmbeddingStore();
        Embedding referenceEmbedding = new Embedding(new float[]{0.5f, 1.5f});
        this.assertThat(store.findRelevant("abc", referenceEmbedding, 12)).contains((Object[])new EmbeddingMatch[]{new EmbeddingMatch(Double.valueOf(0.5), "id", referenceEmbedding, (Object)"abc, [0.5, 1.5], 12, 0.00")});
    }

    public static class MinimalEmbeddingStore
    implements EmbeddingStore<String> {
        public String add(Embedding embedding) {
            return null;
        }

        public void add(String id, Embedding embedding) {
        }

        public String add(Embedding embedding, String s) {
            return null;
        }

        public List<String> addAll(List<Embedding> embeddings) {
            return null;
        }

        public List<String> addAll(List<Embedding> embeddings, List<String> embedded) {
            return null;
        }

        public List<EmbeddingMatch<String>> findRelevant(Embedding referenceEmbedding, int maxResults, double minScore) {
            return Collections.singletonList(new EmbeddingMatch(Double.valueOf(0.5), "id", referenceEmbedding, (Object)String.format(Locale.US, "%s, %d, %.2f", referenceEmbedding.vectorAsList(), maxResults, minScore)));
        }
    }

    public static class MemoryIdEmbeddingStore
    extends MinimalEmbeddingStore {
        public List<EmbeddingMatch<String>> findRelevant(Object memoryId, Embedding referenceEmbedding, int maxResults, double minScore) {
            return Collections.singletonList(new EmbeddingMatch(Double.valueOf(0.5), "id", referenceEmbedding, (Object)String.format(Locale.US, "%s, %s, %d, %.2f", memoryId, referenceEmbedding.vectorAsList(), maxResults, minScore)));
        }
    }
}

