/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class EmbeddingMatchTest
implements WithAssertions {
    EmbeddingMatchTest() {
    }

    @Test
    public void test() {
        EmbeddingMatch em = new EmbeddingMatch(Double.valueOf(0.5), "embeddingId", Embedding.from((float[])new float[]{3.5f, -2.0f}), (Object)"abc");
        this.assertThat(em.score()).isEqualTo(0.5);
        this.assertThat(em.embeddingId()).isEqualTo("embeddingId");
        this.assertThat(em.embedding().vector()).contains(new float[]{3.5f, -2.0f});
        this.assertThat((String)em.embedded()).isEqualTo("abc");
        this.assertThat(em).hasToString("EmbeddingMatch { score = 0.5, embedded = abc, embeddingId = embeddingId, embedding = Embedding { vector = [3.5, -2.0] } }");
    }

    @Test
    public void test_equals_hash() {
        EmbeddingMatch em1 = new EmbeddingMatch(Double.valueOf(0.5), "embeddingId", Embedding.from((float[])new float[]{3.5f, -2.0f}), (Object)"abc");
        EmbeddingMatch em2 = new EmbeddingMatch(Double.valueOf(0.5), "embeddingId", Embedding.from((float[])new float[]{3.5f, -2.0f}), (Object)"abc");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(em1).isEqualTo((Object)em1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)em2)).hasSameHashCodeAs((Object)em2);
        this.assertThat(new EmbeddingMatch(Double.valueOf(0.2), "embeddingId", Embedding.from((float[])new float[]{3.5f, -2.0f}), (Object)"abc")).isNotEqualTo((Object)em1);
        this.assertThat(new EmbeddingMatch(Double.valueOf(0.5), "changed", Embedding.from((float[])new float[]{3.5f, -2.0f}), (Object)"abc")).isNotEqualTo((Object)em1);
        this.assertThat(new EmbeddingMatch(Double.valueOf(0.5), "embeddingId", Embedding.from((float[])new float[]{8.5f, -2.0f}), (Object)"abc")).isNotEqualTo((Object)em1);
        this.assertThat(new EmbeddingMatch(Double.valueOf(0.5), "embeddingId", Embedding.from((float[])new float[]{3.5f, -2.0f}), (Object)"xyz")).isNotEqualTo((Object)em1);
    }
}

