/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content.aggregator;

import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.content.aggregator.ContentAggregator;
import dev.langchain4j.rag.content.aggregator.DefaultContentAggregator;
import dev.langchain4j.rag.query.Query;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class DefaultContentAggregatorTest {
    ContentAggregator aggregator = new DefaultContentAggregator();

    DefaultContentAggregatorTest() {
    }

    @Test
    void should_return_same_contents_when_single_query_and_single_contents() {
        Query query = Query.from((String)"query");
        Content content1 = Content.from((String)"content 1");
        Content content2 = Content.from((String)"content 2");
        Map<Query, List<List<Content>>> queryToContents = Collections.singletonMap(query, Collections.singletonList(Arrays.asList(content1, content2)));
        List aggregated = this.aggregator.aggregate(queryToContents);
        Assertions.assertThat((List)aggregated).containsExactly((Object[])new Content[]{content1, content2});
    }

    @Test
    void should_fuse_contents_when_single_query_and_multiple_contents() {
        Query query = Query.from((String)"query");
        Content content1 = Content.from((String)"content 1");
        Content content2 = Content.from((String)"content 2");
        Content content3 = Content.from((String)"content 3");
        Content content4 = Content.from((String)"content 4");
        Map<Query, List<List>> queryToContents = Collections.singletonMap(query, Arrays.asList(Arrays.asList(content1, content2), Arrays.asList(content3, content4)));
        List aggregated = this.aggregator.aggregate(queryToContents);
        Assertions.assertThat((List)aggregated).containsExactly((Object[])new Content[]{content1, content3, content2, content4});
    }

    @Test
    void should_fuse_contents_when_single_query_and_multiple_contents_with_repeating_content() {
        Query query = Query.from((String)"query");
        Content content1 = Content.from((String)"content 1");
        Content content2 = Content.from((String)"content");
        Content content3 = Content.from((String)"content");
        Content content4 = Content.from((String)"content 4");
        Map<Query, List<List>> queryToContents = Collections.singletonMap(query, Arrays.asList(Arrays.asList(content1, content2), Arrays.asList(content3, content4)));
        List aggregated = this.aggregator.aggregate(queryToContents);
        Assertions.assertThat((List)aggregated).containsExactly((Object[])new Content[]{content2, content1, content4});
    }

    @Test
    void should_fuse_contents_when_multiple_queries_and_multiple_contents() {
        Query query1 = Query.from((String)"query 1");
        Content content1 = Content.from((String)"content 1");
        Content content2 = Content.from((String)"content 2");
        Content content3 = Content.from((String)"content 3");
        Content content4 = Content.from((String)"content 4");
        Query query2 = Query.from((String)"query 2");
        Content content5 = Content.from((String)"content 5");
        Content content6 = Content.from((String)"content 6");
        Content content7 = Content.from((String)"content 7");
        Content content8 = Content.from((String)"content 8");
        LinkedHashMap<Query, List<List>> queryToContents = new LinkedHashMap<Query, List<List>>();
        queryToContents.put(query1, Arrays.asList(Arrays.asList(content1, content2), Arrays.asList(content3, content4)));
        queryToContents.put(query2, Arrays.asList(Arrays.asList(content5, content6), Arrays.asList(content7, content8)));
        List aggregated = this.aggregator.aggregate(queryToContents);
        Assertions.assertThat((List)aggregated).containsExactly((Object[])new Content[]{content1, content5, content3, content7, content2, content6, content4, content8});
    }

    @Test
    void should_fuse_contents_when_multiple_queries_and_multiple_contents_with_repeating_content_between_queries() {
        Query query1 = Query.from((String)"query 1");
        Content content1 = Content.from((String)"content");
        Content content2 = Content.from((String)"content 2");
        Content content3 = Content.from((String)"content 3");
        Content content4 = Content.from((String)"content 4");
        Query query2 = Query.from((String)"query 2");
        Content content5 = Content.from((String)"content 5");
        Content content6 = Content.from((String)"content 6");
        Content content7 = Content.from((String)"content");
        Content content8 = Content.from((String)"content 8");
        LinkedHashMap<Query, List<List>> queryToContents = new LinkedHashMap<Query, List<List>>();
        queryToContents.put(query1, Arrays.asList(Arrays.asList(content1, content2), Arrays.asList(content3, content4)));
        queryToContents.put(query2, Arrays.asList(Arrays.asList(content5, content6), Arrays.asList(content7, content8)));
        List aggregated = this.aggregator.aggregate(queryToContents);
        Assertions.assertThat((List)aggregated).containsExactly((Object[])new Content[]{content1, content5, content3, content2, content6, content4, content8});
    }

    @ParameterizedTest
    @MethodSource
    void should_return_empty_list_when_there_is_no_content_to_rerank(Map<Query, Collection<List<Content>>> queryToContents) {
        DefaultContentAggregator aggregator = new DefaultContentAggregator();
        List aggregated = aggregator.aggregate(queryToContents);
        Assertions.assertThat((List)aggregated).isEmpty();
    }

    private static Stream<Arguments> should_return_empty_list_when_there_is_no_content_to_rerank() {
        return Stream.builder().add(Arguments.of((Object[])new Object[]{Collections.emptyMap()})).add(Arguments.of((Object[])new Object[]{Collections.singletonMap(Query.from((String)"query"), Collections.emptyList())})).add(Arguments.of((Object[])new Object[]{Collections.singletonMap(Query.from((String)"query"), Collections.singletonList(Collections.emptyList()))})).add(Arguments.of((Object[])new Object[]{Collections.singletonMap(Query.from((String)"query"), Arrays.asList(Collections.emptyList(), Collections.emptyList()))})).build();
    }
}

