/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.moderation;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.model.output.Response;
import java.util.List;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class ModerationModelTest
implements WithAssertions {
    ModerationModelTest() {
    }

    @Test
    public void test_moderate_prompt() {
        FlagEverythingModel model = new FlagEverythingModel();
        Response response = model.moderate(Prompt.from((String)"Hello, world!"));
        this.assertThat(response).isEqualTo((Object)Response.from((Object)Moderation.flagged((String)"Hello, world!")));
    }

    @Test
    public void test_moderate_chat_message() {
        FlagEverythingModel model = new FlagEverythingModel();
        Response response = model.moderate((ChatMessage)UserMessage.from((String)"Hello, world!"));
        this.assertThat(response).isEqualTo((Object)Response.from((Object)Moderation.flagged((String)"Hello, world!")));
    }

    @Test
    public void test_moderate_TextSegment() {
        FlagEverythingModel model = new FlagEverythingModel();
        Response response = model.moderate(TextSegment.from((String)"Hello, world!"));
        this.assertThat(response).isEqualTo((Object)Response.from((Object)Moderation.flagged((String)"Hello, world!")));
    }

    public static class FlagEverythingModel
    implements ModerationModel {
        public Response<Moderation> moderate(String text) {
            return Response.from((Object)Moderation.flagged((String)text));
        }

        public Response<Moderation> moderate(List<ChatMessage> messages) {
            return Response.from((Object)Moderation.flagged((String)messages.get(0).text()));
        }
    }
}

