/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.DimensionAwareEmbeddingModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class DimensionAwareEmbeddingModelTest
implements WithAssertions {
    DimensionAwareEmbeddingModelTest() {
    }

    @Test
    void should_return_correct_dimension_and_cached() {
        DimensionAwareEmbeddingModelImpl model = new DimensionAwareEmbeddingModelImpl("test-model");
        this.assertThat(model.dimension()).isEqualTo(2);
        this.assertThat(model.dimension()).isEqualTo(2);
    }

    @Test
    void should_return_init_dimension() {
        DimensionAwareEmbeddingModelImpl model = new DimensionAwareEmbeddingModelImpl("test-model", 5);
        this.assertThat(model.dimension()).isEqualTo(5);
    }

    public static class DimensionAwareEmbeddingModelImpl
    extends DimensionAwareEmbeddingModel {
        final String modelName;

        DimensionAwareEmbeddingModelImpl(String modelName) {
            this.modelName = modelName;
        }

        DimensionAwareEmbeddingModelImpl(String modelName, Integer dimension) {
            this.modelName = modelName;
            this.dimension = dimension;
        }

        public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
            List embeddings = textSegments.stream().map(ts -> new Embedding(new float[]{ts.text().length(), ts.text().hashCode()})).collect(Collectors.toList());
            int tokenUsage = textSegments.stream().mapToInt(ts -> ts.text().length()).sum();
            return Response.from(embeddings, (TokenUsage)new TokenUsage(Integer.valueOf(tokenUsage)), (FinishReason)FinishReason.STOP);
        }
    }
}

