/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.mock;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChatModelMock
implements ChatLanguageModel {
    private final String staticResponse;
    private final RuntimeException exception;
    private final List<List<ChatMessage>> requests = Collections.synchronizedList(new ArrayList());

    public ChatModelMock(String staticResponse) {
        this.staticResponse = ValidationUtils.ensureNotBlank((String)staticResponse, (String)"staticResponse");
        this.exception = null;
    }

    public ChatModelMock(RuntimeException exception) {
        this.staticResponse = null;
        this.exception = (RuntimeException)ValidationUtils.ensureNotNull((Object)exception, (String)"exception");
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        this.requests.add(new ArrayList<ChatMessage>(messages));
        if (this.exception != null) {
            throw this.exception;
        }
        return Response.from((Object)AiMessage.from((String)this.staticResponse));
    }

    public String userMessageText() {
        if (this.requests.size() != 1) {
            throw Exceptions.runtime((String)("Expected exactly 1 request, got: " + this.requests.size()), (Object[])new Object[0]);
        }
        List<ChatMessage> messages = this.requests.get(0);
        if (messages.size() != 1) {
            throw Exceptions.runtime((String)("Expected exactly 1 message, got: " + messages.size()), (Object[])new Object[0]);
        }
        ChatMessage message = messages.get(0);
        if (!(message instanceof UserMessage)) {
            throw Exceptions.runtime((String)("Expected exactly UserMessage, got: " + message), (Object[])new Object[0]);
        }
        return message.text();
    }

    public static ChatModelMock thatAlwaysResponds(String response) {
        return new ChatModelMock(response);
    }

    public static ChatModelMock thatAlwaysThrowsException() {
        return ChatModelMock.thatAlwaysThrowsExceptionWithMessage("Something went wrong, but this is an expected exception");
    }

    public static ChatModelMock thatAlwaysThrowsExceptionWithMessage(String message) {
        return new ChatModelMock(new RuntimeException(message));
    }
}

