/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.output.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class StreamingChatLanguageModelTest
implements WithAssertions {
    StreamingChatLanguageModelTest() {
    }

    @Test
    public void test_not_supported() {
        StreamingUpperCaseEchoModel model = new StreamingUpperCaseEchoModel();
        CollectorResponseHandler handler = new CollectorResponseHandler();
        ArrayList messages = new ArrayList();
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> model.generate(messages, new ArrayList(), handler)).withMessageContaining("Tools are currently not supported by this model");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> model.generate(messages, ToolSpecification.builder().name("foo").build(), handler)).withMessageContaining("Tools are currently not supported by this model");
    }

    @Test
    public void test_generate() {
        StreamingUpperCaseEchoModel model = new StreamingUpperCaseEchoModel();
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(new UserMessage("Hello"));
        messages.add(new AiMessage("Hi"));
        messages.add(new UserMessage("How are you?"));
        CollectorResponseHandler handler = new CollectorResponseHandler();
        model.generate(messages, handler);
        Response response = handler.responses().get(0);
        this.assertThat(((AiMessage)response.content()).text()).isEqualTo("HOW ARE YOU?");
        this.assertThat(response.tokenUsage()).isNull();
        this.assertThat((Comparable)response.finishReason()).isNull();
        CollectorResponseHandler handler2 = new CollectorResponseHandler();
        model.generate("How are you?", handler2);
        Response response2 = handler2.responses().get(0);
        this.assertThat(((AiMessage)response2.content()).text()).isEqualTo("HOW ARE YOU?");
        this.assertThat(response2.tokenUsage()).isNull();
        this.assertThat((Comparable)response2.finishReason()).isNull();
    }

    public static class StreamingUpperCaseEchoModel
    implements StreamingChatLanguageModel {
        public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
            ChatMessage lastMessage = messages.get(messages.size() - 1);
            Response response = new Response((Object)new AiMessage(lastMessage.text().toUpperCase(Locale.ROOT)));
            handler.onComplete(response);
        }
    }

    public static final class CollectorResponseHandler<T>
    implements StreamingResponseHandler<T> {
        private final List<Response<T>> responses = new ArrayList<Response<T>>();

        public List<Response<T>> responses() {
            return this.responses;
        }

        public void onNext(String token) {
        }

        public void onError(Throwable error) {
        }

        public void onComplete(Response<T> response) {
            this.responses.add(response);
        }
    }
}

