/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import com.sun.net.httpserver.HttpServer;
import dev.langchain4j.internal.Utils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class UtilsTest {
    UtilsTest() {
    }

    @Test
    public void test_getOrDefault() {
        Assertions.assertThat((String)((String)Utils.getOrDefault((Object)"foo", (Object)"bar"))).isEqualTo("foo");
        Assertions.assertThat((String)((String)Utils.getOrDefault(null, (Object)"bar"))).isEqualTo("bar");
        Assertions.assertThat((String)((String)Utils.getOrDefault((Object)"foo", () -> "bar"))).isEqualTo("foo");
        Assertions.assertThat((String)((String)Utils.getOrDefault(null, () -> "bar"))).isEqualTo("bar");
    }

    @Test
    public void test_isNullOrBlank() {
        Assertions.assertThat((boolean)Utils.isNullOrBlank(null)).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrBlank((String)"")).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrBlank((String)" ")).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrBlank((String)"foo")).isFalse();
        Assertions.assertThat((boolean)Utils.isNotNullOrBlank(null)).isFalse();
        Assertions.assertThat((boolean)Utils.isNotNullOrBlank((String)"")).isFalse();
        Assertions.assertThat((boolean)Utils.isNotNullOrBlank((String)" ")).isFalse();
        Assertions.assertThat((boolean)Utils.isNotNullOrBlank((String)"foo")).isTrue();
    }

    @Test
    public void test_string_isNullOrEmpty() {
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((String)null)).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((String)"")).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((String)" ")).isFalse();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((String)"\n")).isFalse();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((String)"foo")).isFalse();
    }

    @Test
    public void test_string_isNotNullOrEmpty() {
        Assertions.assertThat((boolean)Utils.isNotNullOrEmpty(null)).isFalse();
        Assertions.assertThat((boolean)Utils.isNotNullOrEmpty((String)"")).isFalse();
        Assertions.assertThat((boolean)Utils.isNotNullOrEmpty((String)" ")).isTrue();
        Assertions.assertThat((boolean)Utils.isNotNullOrEmpty((String)"\n")).isTrue();
        Assertions.assertThat((boolean)Utils.isNotNullOrEmpty((String)"foo")).isTrue();
    }

    @Test
    public void test_areNotNullOrBlank() {
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[0])).isFalse();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{null})).isFalse();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{""})).isFalse();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{" "})).isFalse();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{"foo"})).isTrue();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{"foo", "bar"})).isTrue();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{"foo", null})).isFalse();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{null, "bar"})).isFalse();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{null, null})).isFalse();
    }

    @Test
    public void test_collection_isNullOrEmpty() {
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((Collection)null)).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty(Collections.emptyList())).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty(Collections.singletonList("abc"))).isFalse();
    }

    @Test
    public void test_iterable_isNullOrEmpty() {
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((Iterable)null)).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty(Collections.emptyList())).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty(Collections.singletonList("abc"))).isFalse();
    }

    @Test
    public void test_isCollectionEmpty() {
        Assertions.assertThat((boolean)Utils.isCollectionEmpty(null)).isTrue();
        Assertions.assertThat((boolean)Utils.isCollectionEmpty(Collections.emptyList())).isTrue();
        Assertions.assertThat((boolean)Utils.isCollectionEmpty(Collections.singletonList("abc"))).isFalse();
    }

    @Test
    public void test_repeat() {
        Assertions.assertThat((String)Utils.repeat((String)"foo", (int)0)).isEqualTo("");
        Assertions.assertThat((String)Utils.repeat((String)"foo", (int)1)).isEqualTo("foo");
        Assertions.assertThat((String)Utils.repeat((String)"foo", (int)2)).isEqualTo("foofoo");
        Assertions.assertThat((String)Utils.repeat((String)"foo", (int)3)).isEqualTo("foofoofoo");
    }

    @Test
    void randomUUIDWorks() {
        String uuid1 = Utils.randomUUID();
        String uuid2 = Utils.randomUUID();
        ((AbstractStringAssert)Assertions.assertThat((String)uuid1).isNotNull()).isNotEmpty();
        ((AbstractStringAssert)Assertions.assertThat((String)uuid2).isNotNull()).isNotEmpty();
        Assertions.assertThat((String)uuid1).isNotEqualTo((Object)uuid2);
        Assertions.assertThat((Comparable)UUID.fromString(uuid1)).isInstanceOf(UUID.class);
        Assertions.assertThat((Comparable)UUID.fromString(uuid2)).isInstanceOf(UUID.class);
    }

    @Test
    void generateUUIDFromTextWorks() {
        String input1 = "Hello";
        String input2 = "World";
        String uuidFromInput1 = Utils.generateUUIDFrom((String)input1);
        String uuidFromInput2 = Utils.generateUUIDFrom((String)input2);
        ((AbstractStringAssert)Assertions.assertThat((String)uuidFromInput1).isNotNull()).isNotEmpty();
        ((AbstractStringAssert)Assertions.assertThat((String)uuidFromInput2).isNotNull()).isNotEmpty();
        Assertions.assertThat((String)uuidFromInput1).isNotEqualTo((Object)uuidFromInput2);
        Assertions.assertThat((Comparable)UUID.fromString(uuidFromInput1)).isInstanceOf(UUID.class);
        Assertions.assertThat((Comparable)UUID.fromString(uuidFromInput2)).isInstanceOf(UUID.class);
        Assertions.assertThat((String)Utils.generateUUIDFrom((String)input1)).isEqualTo(uuidFromInput1);
    }

    @Test
    void generateUUIDFromEmptyInputWorks() {
        String uuidFromEmptyInput = Utils.generateUUIDFrom((String)"");
        ((AbstractStringAssert)Assertions.assertThat((String)uuidFromEmptyInput).isNotNull()).isNotEmpty();
        Assertions.assertThat((Comparable)UUID.fromString(uuidFromEmptyInput)).isInstanceOf(UUID.class);
    }

    @Test
    void generateUUIDFromNullInputWorks() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> Utils.generateUUIDFrom(null));
    }

    @MethodSource
    @ParameterizedTest
    void test_quoted(String string, String expected) {
        Assertions.assertThat((String)Utils.quoted((Object)string)).isEqualTo(expected);
    }

    static Stream<Arguments> test_quoted() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, "null"}), Arguments.of((Object[])new Object[]{"", "\"\""}), Arguments.of((Object[])new Object[]{" ", "\" \""}), Arguments.of((Object[])new Object[]{"hello", "\"hello\""}));
    }

    @Test
    public void test_firstChars() {
        Assertions.assertThat((String)Utils.firstChars(null, (int)3)).isNull();
        Assertions.assertThat((String)Utils.firstChars((String)"", (int)3)).isEmpty();
        Assertions.assertThat((String)Utils.firstChars((String)"foo", (int)3)).isEqualTo("foo");
        Assertions.assertThat((String)Utils.firstChars((String)"foobar", (int)3)).isEqualTo("foo");
    }

    @Test
    public void test_readBytes() throws IOException {
        HttpServer httpServer = HttpServer.create(new InetSocketAddress(0), 0);
        try {
            int port = httpServer.getAddress().getPort();
            httpServer.createContext("/ok_endpoint", exchange -> {
                byte[] response = "hello".getBytes();
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            httpServer.createContext("/error_endpoint", exchange -> {
                byte[] response = "nope".getBytes();
                exchange.sendResponseHeaders(500, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            httpServer.start();
            Assertions.assertThat((byte[])Utils.readBytes((String)("http://localhost:" + port + "/ok_endpoint"))).isEqualTo((Object)"hello".getBytes());
            Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> Utils.readBytes((String)("http://localhost:" + port + "/error_endpoint"))).withMessageContaining("Error while reading: 500");
        }
        finally {
            httpServer.stop(0);
        }
    }

    @Test
    void test_copyIfNotNull() {
        Assertions.assertThat((List)Utils.copyIfNotNull(null)).isNull();
        Assertions.assertThat((List)Utils.copyIfNotNull(Collections.emptyList())).isEmpty();
        Assertions.assertThat((List)Utils.copyIfNotNull(Collections.singletonList("one"))).containsExactly((Object[])new String[]{"one"});
        Assertions.assertThat((List)Utils.copyIfNotNull(Arrays.asList("one", "two"))).containsExactly((Object[])new String[]{"one", "two"});
    }
}

